/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg;

import ej.microui.display.LLUIDisplay;
import ej.microui.display.MicroUIGraphicsContext;
import ej.microvg.CommandDecoder;
import ej.microvg.image.pathdata.PathData;
import ej.microvg.paint.VGPaint;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Util {
    private Util() {
    }

    public static int getDisplayColor(int color) {
        int alpha = color & 0xFF000000;
        int rgb = LLUIDisplay.Instance.convertARGBColorToColorToDraw(color) & 0xFFFFFF;
        return alpha | rgb;
    }

    public static void setClip(Graphics2D gc2d, MicroUIGraphicsContext gc, Rectangle bounds, AffineTransform transform) {
        Util.setClip(gc2d, gc, bounds.getMinX() + 0.5, bounds.getMinY() + 0.5, bounds.getMaxX() - 1.0 + 0.5, bounds.getMaxY() - 1.0 + 0.5, transform);
    }

    public static void setClip(Graphics2D gc2d, MicroUIGraphicsContext gc, GeneralPath path, AffineTransform transform) {
        Rectangle bounds = path.getBounds();
        Util.setClip(gc2d, gc, bounds.getMinX(), bounds.getMinY(), bounds.getMaxX(), bounds.getMaxY(), transform);
    }

    public static void setClip(Graphics2D gc2d, MicroUIGraphicsContext gc, double pathLeft, double pathTop, double pathRight, double pathBottom, AffineTransform transform) {
        if (pathRight <= pathLeft || pathBottom <= pathTop) {
            gc2d.setClip(0, 0, 0, 0);
        } else {
            Point2D.Double min = new Point2D.Double();
            transform.transform(new Point2D.Double(pathLeft, pathTop), min);
            Point2D max = (Point2D)min.clone();
            Util.updateBounds(pathRight, pathTop, transform, min, max);
            Util.updateBounds(pathRight, pathBottom, transform, min, max);
            Util.updateBounds(pathLeft, pathBottom, transform, min, max);
            Util.updateBounds(pathRight, pathTop, transform, min, max);
            int clipX1 = Math.max((int)((Point2D)min).getX(), gc.getClipX1());
            int clipY1 = Math.max((int)((Point2D)min).getY(), gc.getClipY1());
            int clipX2 = Math.min((int)max.getX(), gc.getClipX2());
            int clipY2 = Math.min((int)max.getY(), gc.getClipY2());
            gc2d.setClip(clipX1, clipY1, clipX2 - clipX1 + 1, clipY2 - clipY1 + 1);
        }
    }

    private static void updateBounds(double x, double y, AffineTransform transform, Point2D min, Point2D max) {
        Point2D.Double temp = new Point2D.Double();
        transform.transform(new Point2D.Double(x, y), temp);
        double minX = min.getX();
        double minY = min.getY();
        double maxX = max.getX();
        double maxY = max.getY();
        if (((Point2D)temp).getX() < minX) {
            minX = ((Point2D)temp).getX();
        }
        if (((Point2D)temp).getY() < minY) {
            minY = ((Point2D)temp).getY();
        }
        if (((Point2D)temp).getX() > maxX) {
            maxX = ((Point2D)temp).getX();
        }
        if (((Point2D)temp).getY() > maxY) {
            maxY = ((Point2D)temp).getY();
        }
        min.setLocation(minX, minY);
        max.setLocation(maxX, maxY);
    }

    public static int append(byte[] array, int offset, byte b) {
        array[offset++] = b;
        return offset;
    }

    public static int append(byte[] array, int offset, float v) {
        return Util.append(array, offset, Float.floatToIntBits(v));
    }

    public static int append(byte[] array, int offset, int i) {
        array[offset++] = (byte)i;
        array[offset++] = (byte)(i >> 8);
        array[offset++] = (byte)(i >> 16);
        array[offset++] = (byte)(i >> 24);
        return offset;
    }

    public static int append(byte[] array, int offset, char c) {
        array[offset++] = (byte)c;
        array[offset++] = (byte)(c >> 8);
        return offset;
    }

    public static int append(byte[] array, int offset, short s) {
        array[offset++] = (byte)s;
        array[offset++] = (byte)(s >> 8);
        return offset;
    }

    public static byte getByte(byte[] array, int offset) {
        return array[offset];
    }

    public static int getUnsignedByte(byte[] array, int offset) {
        byte ret = Util.getByte(array, offset);
        return ret & 0xFF;
    }

    public static char getChar(byte[] array, int offset) {
        char c = (char)(array[offset++] & 0xFF);
        c = (char)(c | (array[offset] & 0xFF) << 8);
        return c;
    }

    public static int getInt(byte[] array, int offset) {
        int i = array[offset++] & 0xFF;
        i |= (array[offset++] & 0xFF) << 8;
        i |= (array[offset++] & 0xFF) << 16;
        return i |= (array[offset] & 0xFF) << 24;
    }

    public static float getFloat(byte[] array, int offset) {
        return Float.intBitsToFloat(Util.getInt(array, offset));
    }

    public static Rectangle getGraphicsContextClip(MicroUIGraphicsContext gc) {
        return new Rectangle(gc.getClipX1(), gc.getClipY1(), gc.getClipX2() - gc.getClipX1() + 1, gc.getClipY2() - gc.getClipY1() + 1);
    }

    public static Color getGraphicsContextColor(MicroUIGraphicsContext gc) {
        return new Color(gc.getMicroUIColor());
    }

    public static Object getImplementation(Class<?> clazz, Object fallback) {
        try {
            String impl = System.getProperty("com.microej.microvg.implementation");
            return Class.forName(String.valueOf(clazz.getPackage().getName()) + "." + Util.capitalize(impl) + clazz.getSimpleName()).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            return fallback;
        }
    }

    private static String capitalize(String string) {
        char firstChar = string.charAt(0);
        string = string.toLowerCase().substring(1);
        return String.valueOf(Character.toUpperCase(firstChar)) + string;
    }

    public static boolean isFeatureEnabled(String feature) {
        try {
            return !System.getProperty("com.microej.microvg." + feature).equalsIgnoreCase("false");
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    public static int limit(int value, int min, int max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static float limit(float value, float min, float max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static Color[] getColors(int[] source, int offset, int count, int alpha) {
        Color[] colors = new Color[count];
        int i = 0;
        while (i < count) {
            colors[i] = new Color(VGPaint.applyOpacity(Util.getDisplayColor(source[offset + i]), alpha), true);
            ++i;
        }
        return colors;
    }

    public static float[] getGradientFractions(int[] gradientData, int offsetFractions, int count) {
        float[] fractions = new float[count];
        int i = 0;
        while (i < count) {
            fractions[i] = Float.intBitsToFloat(gradientData[offsetFractions + i]);
            ++i;
        }
        return fractions;
    }

    public static int getPathCommandParametersNumber(int command) {
        switch (command) {
            default: {
                return 0;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return 2;
            }
            case 5: 
            case 6: {
                return 4;
            }
            case 7: 
            case 8: 
        }
        return 6;
    }

    public static ByteBuffer derive(ByteBuffer buffer, int offset) {
        return Util.derive(buffer, offset, buffer.array().length - offset);
    }

    public static ByteBuffer derive(ByteBuffer buffer, int offset, int length) {
        return ByteBuffer.wrap(buffer.array(), offset, length).order(ByteOrder.LITTLE_ENDIAN);
    }

    public static void skip(ByteBuffer buffer, int nbElements) {
        buffer.position(buffer.position() + nbElements);
    }

    public static GeneralPath toPath(PathData path, CommandDecoder decoder) {
        double xPos = 0.0;
        double yPos = 0.0;
        GeneralPath p = new GeneralPath();
        try {
            while (path.hasRemainingCommand()) {
                int cmd = decoder.decodeCommand(path.nextCommand());
                switch (cmd) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        xPos = path.nextCoordinate();
                        yPos = path.nextCoordinate();
                        p.moveTo(xPos, yPos);
                        break;
                    }
                    case 2: {
                        p.moveTo(xPos += path.nextCoordinate(), yPos += path.nextCoordinate());
                        break;
                    }
                    case 3: {
                        xPos = path.nextCoordinate();
                        yPos = path.nextCoordinate();
                        p.lineTo(xPos, yPos);
                        break;
                    }
                    case 4: {
                        p.lineTo(xPos += path.nextCoordinate(), yPos += path.nextCoordinate());
                        break;
                    }
                    case 5: {
                        double cx = path.nextCoordinate();
                        double cy = path.nextCoordinate();
                        xPos = path.nextCoordinate();
                        yPos = path.nextCoordinate();
                        p.quadTo(cx, cy, xPos, yPos);
                        break;
                    }
                    case 6: {
                        double cx = xPos + path.nextCoordinate();
                        double cy = yPos + path.nextCoordinate();
                        p.quadTo(cx, cy, xPos += path.nextCoordinate(), yPos += path.nextCoordinate());
                        break;
                    }
                    case 7: {
                        double c1x = path.nextCoordinate();
                        double c1y = path.nextCoordinate();
                        double c2x = path.nextCoordinate();
                        double c2y = path.nextCoordinate();
                        double x = path.nextCoordinate();
                        double y = path.nextCoordinate();
                        p.curveTo(c1x, c1y, c2x, c2y, x, y);
                        xPos = x;
                        yPos = y;
                        break;
                    }
                    case 8: {
                        double c1x = xPos + path.nextCoordinate();
                        double c1y = yPos + path.nextCoordinate();
                        double c2x = xPos + path.nextCoordinate();
                        double c2y = yPos + path.nextCoordinate();
                        p.curveTo(c1x, c1y, c2x, c2y, xPos += path.nextCoordinate(), yPos += path.nextCoordinate());
                        break;
                    }
                    default: {
                        System.out.println("Unsupported command: " + cmd);
                    }
                }
            }
        }
        catch (BufferUnderflowException bufferUnderflowException) {}
        p.closePath();
        return p;
    }
}

