/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg;

import com.is2t.hil.HIL;
import ej.microvg.VectorGraphicsNatives;
import ej.microvg.path.LLVGDynamicPathImpl;

public class PathNatives {
    private PathNatives() {
    }

    private static LLVGDynamicPathImpl getPathEngine() {
        return VectorGraphicsNatives.getDynamicPathEngine();
    }

    public static int initializePath(byte[] path, int length) {
        int ret = PathNatives.getPathEngine().initializePath(path, length);
        if (ret == 0) {
            HIL.getInstance().flushContent((Object)path, 0, PathNatives.getPathEngine().getPathHeaderSize());
        }
        return ret;
    }

    public static int appendPathCommand(byte[] path, int length, int cmd, float x, float y) {
        int index = PathNatives.extendPath(path, length, cmd, 2);
        return index > 0 ? PathNatives.flushPath(path, index, PathNatives.getPathEngine().appendPathCommand(path, index, cmd, x, y)) : -index;
    }

    public static int appendPathCommand(byte[] path, int length, int cmd, float x1, float y1, float x2, float y2) {
        if (cmd == 0) {
            return PathNatives.closePath(path, length, x1, y1, x2, y2);
        }
        int index = PathNatives.extendPath(path, length, cmd, 4);
        return index > 0 ? PathNatives.flushPath(path, index, PathNatives.getPathEngine().appendPathCommand(path, index, cmd, x1, y1, x2, y2)) : -index;
    }

    private static int closePath(byte[] path, int length, float x1, float y1, float x2, float y2) {
        int index = PathNatives.extendPath(path, length, 0, 0);
        if (index > 0) {
            return PathNatives.flushPath(path, index, PathNatives.getPathEngine().appendPathCommand(path, index, 0));
        }
        return -index;
    }

    public static int appendPathCommand(byte[] path, int length, int cmd, float x1, float y1, float x2, float y2, float x3, float y3) {
        int index = PathNatives.extendPath(path, length, cmd, 6);
        return index > 0 ? PathNatives.flushPath(path, index, PathNatives.getPathEngine().appendPathCommand(path, index, cmd, x1, y1, x2, y2, x3, y3)) : -index;
    }

    public static void reopenPath(byte[] path) {
        HIL.getInstance().refreshContent((Object)path, 0, PathNatives.getPathEngine().getPathHeaderSize());
        PathNatives.getPathEngine().reducePath(path, 0, 0);
        HIL.getInstance().flushContent((Object)path, 0, PathNatives.getPathEngine().getPathHeaderSize());
    }

    private static int extendPath(byte[] path, int length, int cmd, int nbFields) {
        HIL.getInstance().refreshContent((Object)path, 0, PathNatives.getPathEngine().getPathHeaderSize());
        int index = PathNatives.getPathEngine().getPathFreeOffset(path);
        int ret = PathNatives.getPathEngine().extendPath(path, length, cmd, nbFields);
        if (ret != 0) {
            return -ret;
        }
        return index;
    }

    private static int flushPath(byte[] path, int index, int offset) {
        HIL.getInstance().flushContent((Object)path, 0, PathNatives.getPathEngine().getPathHeaderSize());
        HIL.getInstance().flushContent((Object)path, index, offset - index);
        return 0;
    }
}

