/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg;

import com.is2t.hil.HIL;
import com.is2t.hil.NativeInterface;
import ej.microvg.MatrixHelper;

public class MatrixNatives {
    private MatrixNatives() {
    }

    public static void identity(float[] matrix) {
        NativeInterface hil = HIL.getInstance();
        MatrixHelper.identity(matrix);
        hil.flushContent((Object)matrix);
    }

    public static void copy(float[] dest, float[] src) {
        NativeInterface hil = HIL.getInstance();
        hil.refreshContent((Object)src);
        MatrixHelper.copy(dest, src);
        hil.flushContent((Object)dest);
    }

    public static void setTranslate(float[] matrix, float dx, float dy) {
        NativeInterface hil = HIL.getInstance();
        MatrixHelper.reset(matrix, dx, dy);
        hil.flushContent((Object)matrix);
    }

    public static void setScale(float[] matrix, float sx, float sy) {
        NativeInterface hil = HIL.getInstance();
        MatrixHelper.identity(matrix);
        MatrixHelper.scale(matrix, sx, sy);
        hil.flushContent((Object)matrix);
    }

    public static void setRotate(float[] matrix, float degrees) {
        NativeInterface hil = HIL.getInstance();
        MatrixHelper.identity(matrix);
        MatrixHelper.rotate(matrix, degrees);
        hil.flushContent((Object)matrix);
    }

    public static void setConcat(float[] dest, float[] a, float[] b) {
        NativeInterface hil = HIL.getInstance();
        hil.refreshContent((Object)a);
        hil.refreshContent((Object)b);
        MatrixHelper.copy(dest, a);
        MatrixHelper.concatenate(dest, b);
        hil.flushContent((Object)dest);
    }

    public static void translate(float[] matrix, float x, float y) {
        NativeInterface hil = HIL.getInstance();
        hil.refreshContent((Object)matrix);
        MatrixHelper.translate(matrix, x, y);
        hil.flushContent((Object)matrix);
    }

    public static void scale(float[] matrix, float scaleX, float scaleY) {
        NativeInterface hil = HIL.getInstance();
        hil.refreshContent((Object)matrix);
        MatrixHelper.scale(matrix, scaleX, scaleY);
        hil.flushContent((Object)matrix);
    }

    public static void rotate(float[] matrix, float degrees) {
        NativeInterface hil = HIL.getInstance();
        hil.refreshContent((Object)matrix);
        MatrixHelper.rotate(matrix, degrees);
        hil.flushContent((Object)matrix);
    }

    public static void concatenate(float[] matrix, float[] other) {
        NativeInterface hil = HIL.getInstance();
        hil.refreshContent((Object)matrix);
        hil.refreshContent((Object)other);
        MatrixHelper.concatenate(matrix, other);
        hil.flushContent((Object)matrix);
    }

    public static void postTranslate(float[] matrix, float dx, float dy) {
        NativeInterface hil = HIL.getInstance();
        hil.refreshContent((Object)matrix);
        float[] temp = MatrixHelper.create(dx, dy);
        MatrixHelper.concatenate(temp, matrix);
        MatrixHelper.copy(matrix, temp);
        hil.flushContent((Object)matrix);
    }

    public static void postScale(float[] matrix, float sx, float sy) {
        NativeInterface hil = HIL.getInstance();
        hil.refreshContent((Object)matrix);
        float[] temp = MatrixHelper.createIdentity();
        MatrixHelper.scale(temp, sx, sy);
        MatrixHelper.concatenate(temp, matrix);
        MatrixHelper.copy(matrix, temp);
        hil.flushContent((Object)matrix);
    }

    public static void postRotate(float[] matrix, float degrees) {
        NativeInterface hil = HIL.getInstance();
        hil.refreshContent((Object)matrix);
        float[] temp = MatrixHelper.createIdentity();
        MatrixHelper.rotate(temp, degrees);
        MatrixHelper.concatenate(temp, matrix);
        MatrixHelper.copy(matrix, temp);
        hil.flushContent((Object)matrix);
    }

    public static void postConcat(float[] matrix, float[] other) {
        NativeInterface hil = HIL.getInstance();
        hil.refreshContent((Object)matrix);
        hil.refreshContent((Object)other);
        float[] temp = MatrixHelper.create();
        MatrixHelper.copy(temp, other);
        MatrixHelper.concatenate(temp, matrix);
        MatrixHelper.copy(matrix, temp);
        hil.flushContent((Object)matrix);
    }
}

