/*
 * Decompiled with CFR 0.152.
 */
package ej.microvg;

import ej.microvg.FontHolder;
import ej.microvg.VectorFontNatives;
import ej.microvg.VectorGraphicsNatives;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class FontHelper {
    private static final char MIN_HIGH_SURROGATE = '\ud800';
    private static final char MAX_HIGH_SURROGATE = '\udbff';
    private static final int BUFFERED_IMAGE_SIZE = 100;
    private static final int FONT_DEFAULT_EM_SIZE = 2048;
    private static final int JAVA_VERSION_8 = 8;
    public static final int UNLOADED = 0;
    private static final List<FontHolder> loadedFonts = new ArrayList<FontHolder>();

    public static int add(FontHolder font) {
        loadedFonts.add(font);
        return loadedFonts.size();
    }

    public static void remove(int fontHandle) {
        loadedFonts.set(FontHelper.getIndex(fontHandle), null);
    }

    public static int getIndex(int fontHandle) {
        return fontHandle - 1;
    }

    public static Font get(int fontHandle, float size) {
        return loadedFonts.get(FontHelper.getIndex(fontHandle)).getFont().deriveFont(size);
    }

    public static boolean hasComplexLayout(int fontHandle) {
        return loadedFonts.get(FontHelper.getIndex(fontHandle)).hasComplexLayout();
    }

    /*
     * Unable to fully structure code
     */
    public static float stringWidth(char[] string, int face, float size, float letterSpacing) {
        if (FontHelper.hasComplexLayout(face)) {
            rect = FontHelper.getStringShape(string, face, size).getBounds2D();
            return (float)rect.getWidth();
        }
        font = FontHelper.get(face, 2048.0f);
        metrics = FontHelper.getMetrics(font);
        scale = size / 2048.0f;
        length = string.length;
        offset = 0;
        width = 0.0f;
        firstGlyph = true;
        if (!(size <= 0.0f)) ** GOTO lbl35
        return 0.0f;
lbl-1000:
        // 1 sources

        {
            charSize = FontHelper.getNextUtfSize(string, length, offset);
            s = new String(string, offset, charSize);
            advanceX = metrics.charsWidth(string, offset, charSize);
            width += (float)advanceX;
            offset += charSize;
            if (firstGlyph) {
                glyphWidth = FontHelper.getGlyphBounds(font, s).getMaxX() - FontHelper.getGlyphBounds(font, s).getMinX();
                width = 0.0 != glyphWidth ? (float)((double)width - FontHelper.getGlyphBounds(font, s).getMinX()) : (width -= (float)advanceX);
                firstGlyph = false;
            }
            kerning = 0.0f;
            if (offset < length) {
                nextCharSize = FontHelper.getNextUtfSize(string, length, offset);
                nextChar = new String(string, offset, nextCharSize);
                kerning = FontHelper.getKerning(String.valueOf(s) + nextChar, face, 2048.0f);
                width += kerning;
                continue;
            }
            glyphWidth = FontHelper.getGlyphBounds(font, s).getMaxX() - FontHelper.getGlyphBounds(font, s).getMinX();
            if (0.0 != glyphWidth) {
                width = (float)((double)width - ((double)advanceX - FontHelper.getGlyphBounds(font, s).getMaxX()));
                continue;
            }
            if (0.0f == width) continue;
            width -= (float)advanceX;
lbl35:
            // 5 sources

            ** while (offset < length)
        }
lbl36:
        // 1 sources

        width *= scale;
        return width += letterSpacing * (float)(length - 1);
    }

    public static float stringHeight(char[] string, int face, float size) {
        if (size <= 0.0f) {
            return 0.0f;
        }
        if (FontHelper.hasComplexLayout(face)) {
            Rectangle2D rect = FontHelper.getStringShape(string, face, size).getBounds2D();
            return (float)rect.getHeight();
        }
        Font font = FontHelper.get(face, 2048.0f);
        float scale = size / 2048.0f;
        return scale * (float)(FontHelper.getGlyphBounds(font, new String(string)).getMaxY() - FontHelper.getGlyphBounds(font, new String(string)).getMinY());
    }

    public static float getBaselinePosition(int face, float size) {
        Font font = FontHelper.get(face, 2048.0f);
        FontMetrics metrics = FontHelper.getMetrics(font);
        float scale = size / 2048.0f;
        float result = 0.0f;
        if (size <= 0.0f) {
            return 0.0f;
        }
        result = 8 == VectorGraphicsNatives.getJavaVersion() ? (float)(metrics.getMaxAscent() - metrics.getLeading() / 2) : (float)metrics.getMaxAscent();
        return FontHelper.round(result *= scale, FontHelper.getMul(size), false);
    }

    private static float getMul(float v) {
        float mul = 1.0f;
        int i = 0;
        while (i < 5) {
            if (FontHelper.round(v, mul, true) == v) break;
            mul *= 10.0f;
            ++i;
        }
        return mul;
    }

    private static float round(float value, float mul, boolean floor) {
        return (float)((int)(value * mul + (floor ? 0.0f : 0.5f))) / mul;
    }

    private static FontMetrics getMetrics(Font font) {
        return new Canvas().getFontMetrics(font);
    }

    private static Rectangle2D getGlyphBounds(Font font, String s) {
        FontRenderContext frc = new FontRenderContext(null, true, true);
        GlyphVector glyphVector = font.createGlyphVector(frc, s.toCharArray());
        float minX = Float.MAX_VALUE;
        float minY = Float.MAX_VALUE;
        float maxX = -3.4028235E38f;
        float maxY = -3.4028235E38f;
        int nbSegments = 0;
        PathIterator i = glyphVector.getOutline().getPathIterator(null);
        double[] coords = new double[6];
        while (!i.isDone()) {
            int k = i.currentSegment(coords);
            ++nbSegments;
            int nbPoints = 0;
            if (k == 4) {
                nbPoints = 0;
            } else if (k == 1 || k == 0) {
                nbPoints = 1;
            } else if (k == 2) {
                nbPoints = 2;
            } else if (k == 3) {
                nbPoints = 3;
            } else {
                throw new RuntimeException("unexpected segment type (" + k + ")");
            }
            int j = 0;
            while (j < nbPoints) {
                minX = (float)Math.min((double)minX, coords[j]);
                minY = (float)Math.min((double)minY, coords[j + 1]);
                maxX = (float)Math.max((double)maxX, coords[j]);
                maxY = (float)Math.max((double)maxY, coords[j + 1]);
                j += 2;
            }
            i.next();
        }
        if (nbSegments == 0) {
            minX = 0.0f;
            maxX = 0.0f;
            minY = 0.0f;
            maxY = 0.0f;
        }
        return new Rectangle2D.Float(minX, minY, maxX - minX, maxY - minY);
    }

    static float getBearingX(String s, int face, float size) {
        Font font = FontHelper.get(face, 2048.0f);
        float scale = size / 2048.0f;
        return (float)(FontHelper.getGlyphBounds(font, s).getMinX() * (double)scale);
    }

    static float getGlyphWidth(String s, int face, float size) {
        Font font = FontHelper.get(face, 2048.0f);
        float scale = size / 2048.0f;
        return (float)(FontHelper.getGlyphBounds(font, s).getMaxX() - FontHelper.getGlyphBounds(font, s).getMinX()) * scale;
    }

    private static boolean isSurrogateHighPart(int c) {
        return c >= 55296 && c <= 56319;
    }

    public static int getNextUtfSize(char[] string, int length, int offset) {
        return FontHelper.isSurrogateHighPart(string[offset]) && offset + 1 < length ? 2 : 1;
    }

    public static float getAdvanceX(char[] string, int face, float size) {
        Font font = FontHelper.get(face, 2048.0f);
        FontMetrics metrics = FontHelper.getMetrics(font);
        float scale = size / 2048.0f;
        return (float)metrics.charsWidth(string, 0, 1) * scale;
    }

    public static float getKerning(String string, int face, float size) {
        BufferedImage bi = new BufferedImage(100, 100, 2);
        Graphics2D g2d = (Graphics2D)bi.getGraphics();
        Font withoutKerningFont = FontHelper.get(face, size);
        HashMap<TextAttribute, Integer> map = new HashMap<TextAttribute, Integer>();
        map.put(TextAttribute.KERNING, TextAttribute.KERNING_ON);
        Font withKerningFont = withoutKerningFont.deriveFont(map);
        FontMetrics withoutKerningmetrics = g2d.getFontMetrics(withoutKerningFont);
        FontMetrics withKerningMetrics = g2d.getFontMetrics(withKerningFont);
        GlyphVector glyphVectorWithoutKerning = withoutKerningFont.layoutGlyphVector(withoutKerningmetrics.getFontRenderContext(), string.toCharArray(), 0, string.toCharArray().length, 0);
        GlyphVector glyphVectorWithKerning = withKerningFont.layoutGlyphVector(withKerningMetrics.getFontRenderContext(), string.toCharArray(), 0, string.toCharArray().length, 0);
        float withoutMaxX = (float)glyphVectorWithoutKerning.getLogicalBounds().getMaxX();
        float withMaxX = (float)glyphVectorWithKerning.getLogicalBounds().getMaxX();
        return withMaxX - withoutMaxX;
    }

    public static float getHeight(int face, float size) {
        if (size <= 0.0f) {
            return 0.0f;
        }
        Font font = FontHelper.get(face, 2048.0f);
        float scale = size / 2048.0f;
        return scale * (float)FontHelper.getMetrics(font).getHeight();
    }

    public static boolean isClosed(int face) {
        return face == 0;
    }

    public static Shape getStringShape(char[] string, int face, float size) {
        float scaledSize = size * 3.0f;
        Font font = FontHelper.get(face, scaledSize);
        FontMetrics metrics = FontHelper.getMetrics(font);
        int stringWidth = metrics.charsWidth(string, 0, string.length);
        BufferedImage im = new BufferedImage(stringWidth, (int)VectorFontNatives.getHeight(face, scaledSize), 1);
        Graphics2D g2dIm = (Graphics2D)im.getGraphics();
        g2dIm.setFont(font);
        g2dIm.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g2dIm.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2dIm.setColor(Color.BLACK);
        g2dIm.fillRect(0, 0, im.getWidth(), im.getHeight());
        g2dIm.setColor(Color.RED);
        g2dIm.drawChars(string, 0, string.length, 0, (int)VectorFontNatives.getBaselinePosition(face, scaledSize));
        Area area = new Area();
        int maxy = im.getHeight();
        int x = 0;
        while (x < im.getWidth()) {
            Rectangle r;
            int y1 = maxy;
            int y2 = -1;
            int y = 0;
            while (y < im.getHeight()) {
                if ((im.getRGB(x, y) & 0xFFFFFF) != 0) {
                    if (y1 == maxy) {
                        y1 = y;
                        y2 = y;
                    }
                    if (y > y2 + 1) {
                        r = new Rectangle(x, y1, 1, y2 - y1);
                        area.add(new Area(r));
                        y1 = y;
                    }
                    y2 = y;
                }
                ++y;
            }
            if (y2 - y1 >= 0) {
                r = new Rectangle(x, y1, 1, y2 - y1);
                area.add(new Area(r));
            }
            ++x;
        }
        AffineTransform at = new AffineTransform();
        at.translate(0.0, -FontHelper.getBaselinePosition(face, size));
        at.scale(size / scaledSize, size / scaledSize);
        area.transform(at);
        at.setToIdentity();
        at.translate(-area.getBounds().getMinX(), 0.0);
        Shape s = at.createTransformedShape(area);
        return s;
    }
}

