/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.tools.fileSystem;

import com.is2t.tools.ArrayOfChars;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class FileManipulations {
    private static final String CLASS_EXT = ".class";
    private static int CLASS_EX_SIZE = ".class".length();

    public static void copyRecursiveTo(String relativeRessource, String target) {
        FileManipulations.copyRecursiveTo(relativeRessource, target, false);
    }

    public static void copyRecursiveTo(String relativeRessource, String target, boolean excludeCVS) {
        relativeRessource = FileManipulations.replaceSeparator(relativeRessource);
        target = FileManipulations.replaceSeparator(target);
        File ressource = new File(relativeRessource);
        if (excludeCVS && relativeRessource.endsWith("CVS") || relativeRessource.equals(".cvsignore")) {
            return;
        }
        if (ressource.isDirectory()) {
            if (excludeCVS && relativeRessource.endsWith("CVS")) {
                return;
            }
            File targetFile = new File(target);
            if (targetFile.exists()) {
                if (!targetFile.isDirectory()) {
                    throw new RuntimeException("Failed in copy " + ressource + " in " + target);
                }
            } else {
                targetFile.mkdir();
            }
            File[] files = ressource.listFiles();
            int i = files.length;
            while (--i >= 0) {
                FileManipulations.copyRecursiveTo(relativeRessource + File.separatorChar + files[i].getName(), target + File.separatorChar + files[i].getName(), excludeCVS);
            }
        } else {
            if (excludeCVS && relativeRessource.endsWith(".cvsignore")) {
                return;
            }
            File file = new File(target);
            new File(file.getParent()).mkdirs();
            if (!FileManipulations.copy(ressource, file)) {
                throw new RuntimeException("Failed in copy " + ressource + " in " + target);
            }
        }
    }

    public static String replaceSeparator(String filename) {
        if (File.separatorChar == '/') {
            return filename;
        }
        char[] chars = filename.toCharArray();
        ArrayOfChars.hardReplace(chars, '/', File.separatorChar);
        return new String(chars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(File source, File target) {
        FileInputStream in = null;
        FileOutputStream out = null;
        boolean ok = false;
        try {
            int nbRead;
            if (target.exists()) {
                target.delete();
            }
            in = new FileInputStream(source);
            out = new FileOutputStream(target);
            byte[] buffer = new byte[524288];
            while ((nbRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, nbRead);
            }
            ok = true;
        }
        catch (IOException e) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
        return ok;
    }

    public static void rmRecursively(File file) {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            int i = files.length;
            while (--i >= 0) {
                FileManipulations.rmRecursively(files[i]);
            }
        }
        file.delete();
    }

    public static void clearDirectory(String relativeRessource) {
        File ressource = new File(relativeRessource = FileManipulations.replaceSeparator(relativeRessource));
        if (ressource.exists() && ressource.isDirectory()) {
            File[] files = ressource.listFiles();
            int i = files.length;
            while (--i >= 0) {
                FileManipulations.rmRecursively(files[i]);
            }
        }
    }

    public static void cleanCVSdirectories(String root) {
        File file = new File(root);
        if (file.isDirectory()) {
            if (file.getName().equals("CVS")) {
                FileManipulations.rmRecursively(file);
            } else {
                File[] files = file.listFiles();
                int i = files.length;
                while (--i >= 0) {
                    FileManipulations.cleanCVSdirectories(files[i].getAbsolutePath());
                }
            }
        }
    }

    public static void createDirectoriesChain(String dirname) {
        File dir = new File(dirname);
        if (dir.exists()) {
            return;
        }
        String parent = dir.getParent();
        if (parent != null) {
            FileManipulations.createDirectoriesChain(parent);
        }
        dir.mkdir();
    }

    public static File[] listAllFilesRecursively(String dirname) {
        ArrayList<File> lst = FileManipulations.listAllFilesRecursively(dirname, null);
        File[] files = new File[lst.size()];
        lst.toArray(files);
        return files;
    }

    public static ArrayList<File> listAllFilesRecursively(String dirname, String[] filters) {
        ArrayList<File> filesTree = new ArrayList<File>();
        File entry = new File(dirname);
        if (entry.exists() && entry.isDirectory()) {
            int filesLength;
            File[] files = entry.listFiles();
            int i = filesLength = files.length;
            while (--i >= 0) {
                File currentFile = files[i];
                if (currentFile.isFile()) {
                    if (filters != null && !FileManipulations.matches(currentFile.getName(), filters)) continue;
                    filesTree.add(currentFile);
                    continue;
                }
                filesTree.addAll(FileManipulations.listAllFilesRecursively(currentFile.getAbsolutePath(), filters));
            }
        } else {
            throw new IllegalArgumentException("Wrong given path: " + dirname);
        }
        return filesTree;
    }

    public static boolean matches(String source, String[] filters) {
        int i = filters.length;
        while (--i >= 0) {
            if (!source.matches(filters[i])) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<String> listAllClassesRecursively(String dirname, String[] filters) {
        return FileManipulations.listAllClassesRecursively(dirname, filters, dirname.length());
    }

    private static ArrayList<String> listAllClassesRecursively(String dirname, String[] filters, int classpathSize) {
        ArrayList<String> filesTree = new ArrayList<String>();
        File entry = new File(dirname);
        if (entry.exists() && entry.isDirectory()) {
            int filesLength;
            File[] files = entry.listFiles();
            int i = filesLength = files.length;
            while (--i >= 0) {
                File currentFile = files[i];
                if (currentFile.isFile()) {
                    String path = currentFile.getAbsolutePath();
                    if (!path.endsWith(CLASS_EXT)) continue;
                    String classname = path.substring(classpathSize + 1, path.length() - CLASS_EX_SIZE);
                    classname = classname.replace(File.separatorChar, '.');
                    if (filters != null && !FileManipulations.matches(classname, filters)) continue;
                    filesTree.add(classname);
                    continue;
                }
                if (!currentFile.isDirectory()) continue;
                filesTree.addAll(FileManipulations.listAllClassesRecursively(currentFile.getAbsolutePath(), filters, classpathSize));
            }
        } else if (entry.exists() && entry.getName().endsWith(".jar")) {
            filesTree.addAll(FileManipulations.getJavaClassesInJar(entry, filters));
        } else {
            throw new IllegalArgumentException("Bad given path: " + dirname);
        }
        return filesTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getJavaClassesInJar(File jarfile, String[] filters) {
        JarFile jf = null;
        ArrayList<String> filenames = new ArrayList<String>();
        try {
            jf = new JarFile(jarfile, false);
            Enumeration<JarEntry> entries = jf.entries();
            while (entries.hasMoreElements()) {
                String entryName;
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory() || !(entryName = entry.getName()).endsWith(CLASS_EXT)) continue;
                String name = entryName.substring(0, entryName.length() - CLASS_EX_SIZE);
                name = name.replace('/', '.');
                if (filters != null && !FileManipulations.matches(name, filters)) continue;
                filenames.add(name);
            }
        }
        catch (Exception e) {
        }
        finally {
            if (jf != null) {
                try {
                    jf.close();
                }
                catch (IOException ignored) {}
            }
        }
        return filenames;
    }
}

