/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.tools;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteReadWrite {
    public static int readU1(byte[] data, int offset) throws ArrayIndexOutOfBoundsException {
        return data[offset] & 0xFF;
    }

    public static int readU2(byte[] data, int offset) throws ArrayIndexOutOfBoundsException {
        return data[offset] & 0xFF | (data[offset + 1] & 0xFF) << 8;
    }

    public static int readU4(byte[] data, int offset) throws ArrayIndexOutOfBoundsException {
        return data[offset] & 0xFF | (data[offset + 1] & 0xFF) << 8 | (data[offset + 2] & 0xFF) << 16 | (data[offset + 3] & 0xFF) << 24;
    }

    public static long readU8(byte[] data, int offset) throws ArrayIndexOutOfBoundsException {
        return (long)data[offset] & 0xFFL | ((long)data[offset + 1] & 0xFFL) << 8 | ((long)data[offset + 2] & 0xFFL) << 16 | ((long)data[offset + 3] & 0xFFL) << 24 | ((long)data[offset + 4] & 0xFFL) << 32 | ((long)data[offset + 5] & 0xFFL) << 40 | ((long)data[offset + 6] & 0xFFL) << 48 | ((long)data[offset + 7] & 0xFFL) << 56;
    }

    public static byte[] read(byte[] data, int offset, int length) throws ArrayIndexOutOfBoundsException {
        byte[] res = new byte[length];
        System.arraycopy(data, offset, res, 0, length);
        return res;
    }

    public static int readU1(InputStream is) throws IOException {
        int read = is.read();
        if (read == -1) {
            throw new EOFException();
        }
        return read;
    }

    public static int readU2(InputStream is) throws IOException {
        int rl = is.read();
        if (rl == -1) {
            throw new EOFException();
        }
        int rh = is.read();
        if (rh < 0) {
            throw new EOFException();
        }
        return rl | rh << 8;
    }

    public static int readU4(InputStream is) throws IOException {
        int r0 = is.read();
        if (r0 == -1) {
            throw new EOFException();
        }
        int r1 = is.read();
        if (r1 < 0) {
            throw new EOFException();
        }
        int r2 = is.read();
        if (r2 < 0) {
            throw new EOFException();
        }
        int r3 = is.read();
        if (r3 < 0) {
            throw new EOFException();
        }
        return r0 | r1 << 8 | r2 << 16 | r3 << 24;
    }

    public static long readU8(InputStream is) throws IOException {
        int r0 = is.read();
        if (r0 == -1) {
            throw new EOFException();
        }
        int r1 = is.read();
        if (r1 < 0) {
            throw new EOFException();
        }
        int r2 = is.read();
        if (r2 < 0) {
            throw new EOFException();
        }
        int r3 = is.read();
        if (r3 < 0) {
            throw new EOFException();
        }
        int r4 = is.read();
        if (r4 < 0) {
            throw new EOFException();
        }
        int r5 = is.read();
        if (r5 < 0) {
            throw new EOFException();
        }
        int r6 = is.read();
        if (r6 < 0) {
            throw new EOFException();
        }
        int r7 = is.read();
        if (r7 < 0) {
            throw new EOFException();
        }
        return (long)r0 | (long)r1 << 8 | (long)r2 << 16 | (long)r3 << 24 | (long)r4 << 32 | (long)r5 << 40 | (long)r6 << 48 | (long)r7 << 56;
    }

    public static void read(InputStream is, byte[] bytes, int offset, int length) throws IOException {
        int nb;
        for (int nbRead = 0; nbRead < length; nbRead += nb) {
            nb = is.read(bytes, offset + nbRead, length - nbRead);
            if (nb != -1) continue;
            throw new EOFException();
        }
    }

    public static void writeU1(OutputStream stream, int u1) throws IOException {
        stream.write(u1);
    }

    public static void writeU2(OutputStream stream, int u2) throws IOException {
        stream.write(u2 & 0xFF);
        stream.write(u2 >>> 8 & 0xFF);
    }

    public static void writeU1(byte[] bytes, int offset, int u1) {
        bytes[offset] = (byte)u1;
    }

    public static void writeU2(byte[] bytes, int offset, int u2) {
        bytes[offset++] = (byte)u2;
        bytes[offset] = (byte)(u2 >>> 8);
    }

    public static void writeU4(byte[] bytes, int offset, int u4) {
        bytes[offset++] = (byte)u4;
        bytes[offset++] = (byte)(u4 >>> 8);
        bytes[offset++] = (byte)(u4 >>> 16);
        bytes[offset] = (byte)(u4 >>> 24);
    }

    public static void writeU8(byte[] bytes, int offset, long u8) {
        bytes[offset++] = (byte)u8;
        bytes[offset++] = (byte)(u8 >>> 8);
        bytes[offset++] = (byte)(u8 >>> 16);
        bytes[offset++] = (byte)(u8 >>> 24);
        bytes[offset++] = (byte)(u8 >>> 32);
        bytes[offset++] = (byte)(u8 >>> 40);
        bytes[offset++] = (byte)(u8 >>> 48);
        bytes[offset] = (byte)(u8 >>> 56);
    }

    public static void writeBytes(byte[] bytesOut, int offset, byte[] bytesIn) {
        System.arraycopy(bytesIn, 0, bytesOut, offset, bytesIn.length);
    }
}

