/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.tools;

public class ArrayOfCharsToIntTable {
    char[][] keys;
    int keysPtr = -1;
    int[][] entries;
    static final int Threshold = 21;
    static final int DefaultSize = 500;

    public ArrayOfCharsToIntTable() {
        this(500);
    }

    public ArrayOfCharsToIntTable(int keysSize) {
        this(keysSize, keysSize / 21 + 1);
    }

    public ArrayOfCharsToIntTable(int keysSize, int entriesSize) {
        this.keys = new char[keysSize][];
        this.entries = new int[entriesSize][];
        int i = entriesSize;
        while (--i >= 0) {
            this.entries[i] = new int[21];
            this.entries[i][0] = 1;
        }
    }

    public int at(char[] key) {
        int hash = (key.hashCode() & Integer.MAX_VALUE) % this.entries.length;
        int[] values = this.entries[hash];
        if (values == null) {
            return 0;
        }
        int i = values[0];
        while (--i >= 1) {
            if (key != this.keys[values[--i]]) continue;
            return values[i + 1];
        }
        return 0;
    }

    public void atPut(char[] key, int value) {
        int hash = (key.hashCode() & Integer.MAX_VALUE) % this.entries.length;
        int vl = 0;
        int[] values = this.entries[hash];
        int i = vl = values[0];
        while (--i >= 1) {
            if (key != this.keys[values[--i]]) continue;
            values[i + 1] = value;
            return;
        }
        if (vl == 21) {
            this.rehash();
            this.atPut(key, value);
            return;
        }
        try {
            this.keys[++this.keysPtr] = key;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            char[][] cArrayArray = new char[this.keysPtr * 2][];
            this.keys = cArrayArray;
            System.arraycopy(this.keys, 0, cArrayArray, 0, this.keysPtr);
            this.keys[this.keysPtr] = key;
        }
        values[vl] = this.keysPtr;
        values[vl + 1] = value;
        values[0] = vl + 2;
    }

    public char[][] keys() {
        int ni = this.keysPtr + 1;
        char[][] newKeys = new char[ni][];
        newKeys = new char[ni][];
        System.arraycopy(this.keys, 0, newKeys, 0, ni);
        return newKeys;
    }

    public void rehash() {
        boolean needRehash;
        do {
            needRehash = false;
            int[][] oldEntries = this.entries;
            int entriesLength = this.entries.length * 2;
            this.entries = new int[entriesLength][];
            int i = entriesLength;
            while (--i >= 0) {
                this.entries[i] = new int[21];
                this.entries[i][0] = 1;
            }
            i = oldEntries.length;
            while (--i >= 0) {
                int[] oldValues = oldEntries[i];
                int j = oldValues[0];
                while (--j >= 1) {
                    int keyAsInt;
                    char[] key;
                    int hash;
                    int[] values;
                    int length;
                    if ((length = (values = this.entries[hash = ((key = this.keys[keyAsInt = oldValues[--j]]).hashCode() & Integer.MAX_VALUE) % entriesLength])[0]) == values.length) {
                        needRehash = true;
                        int[] nArray = values;
                        values = new int[length + 2];
                        this.entries[hash] = values;
                        System.arraycopy(nArray, 0, values, 0, length);
                    }
                    values[length] = keyAsInt;
                    values[length + 1] = oldValues[j + 1];
                    values[0] = values[0] + 2;
                }
            }
        } while (needRehash);
    }
}

