/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.tools;

public abstract class ArrayOfChars {
    public static int parseInt(char[] chars) {
        return ArrayOfChars.parseInt(chars, 0, chars.length);
    }

    public static int parseInt(char[] chars, int offset, int length) {
        int i = offset - 1;
        int value = 0;
        length += offset;
        while (++i < length) {
            value = value * 10 + (chars[i] - 48);
        }
        return value;
    }

    public static int firstIndexOf(char[] chars, char c) {
        return ArrayOfChars.firstIndexOf(chars, 0, c);
    }

    public static int firstIndexOf(char[] chars, int fromPtr, char c) {
        int i = fromPtr - 1;
        int lg = chars.length;
        while (++i < lg) {
            if (chars[i] != c) continue;
            return i;
        }
        return -1;
    }

    public static void hardReplace(char[] array, char c1, char c2) {
        int i = array.length;
        while (--i >= 0) {
            if (array[i] != c1) continue;
            array[i] = c2;
        }
    }

    public static boolean startWith(char[] array, char[] start) {
        return ArrayOfChars.isSubArray(array, start) == 0;
    }

    public static boolean endsWith(char[] array, char[] end) {
        int arrayLength = array.length;
        int endLength = end.length;
        if (arrayLength < endLength) {
            return false;
        }
        int i = endLength;
        while (--i >= 0) {
            if (array[--arrayLength] == end[i]) continue;
            return false;
        }
        return true;
    }

    public static int isSubArray(char[] array, char[] subarray) {
        return ArrayOfChars.isSubArray(array, subarray, 0);
    }

    public static int isSubArray(char[] array, char[] subarray, int start) {
        return ArrayOfChars.isSubArray(array, subarray, start, array.length);
    }

    public static int isSubArray(char[] array, char[] subarray, int start, int end) {
        if (array == null || subarray == null) {
            return -1;
        }
        int subarraylength = subarray.length;
        if (subarraylength == 0) {
            return 0;
        }
        int index = start - 1;
        int maxIndex = end - subarraylength;
        char c = subarray[0];
        char[] chars = array;
        while (++index <= maxIndex) {
            if (chars[index] != c) continue;
            int i = subarraylength;
            int j = index + i;
            while (i > 0 && chars[--j] == subarray[--i]) {
            }
            if (i != 0) continue;
            return index;
        }
        return -1;
    }

    public static int lastIndexOf(char[] chars, char c) {
        return ArrayOfChars.lastIndexOf(chars, chars.length, c);
    }

    public static int lastIndexOf(char[] chars, int stopPtr, char c) {
        int i = stopPtr;
        while (--i >= 0) {
            if (chars[i] != c) continue;
            return i;
        }
        return -1;
    }

    public static char[][] slices(char[] chars, char c) {
        int start;
        int length = chars.length;
        int[] positions = new int[length];
        int pos = length;
        int i = length;
        while (--i >= 0) {
            if (chars[i] != c) continue;
            positions[--pos] = i;
        }
        int slicesLength = 1 + length - pos;
        if (slicesLength == 1) {
            return new char[][]{chars};
        }
        char[][] slices = new char[slicesLength][];
        int slicesIndex = 0;
        int lengthSlice = positions[pos];
        slices[0] = new char[lengthSlice];
        System.arraycopy(chars, 0, slices[0], 0, lengthSlice);
        while (++pos < length) {
            start = positions[pos - 1] + 1;
            lengthSlice = positions[pos] - start;
            slices[++slicesIndex] = new char[lengthSlice];
            System.arraycopy(chars, start, slices[++slicesIndex], 0, lengthSlice);
        }
        start = positions[pos - 1] + 1;
        lengthSlice = length - start;
        slices[++slicesIndex] = new char[lengthSlice];
        System.arraycopy(chars, start, slices[++slicesIndex], 0, lengthSlice);
        return slices;
    }

    public static boolean equals(char[] array1, char[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        int i = array1.length;
        while (--i >= 0) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIgnoreCase(char[] array1, char[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        int i = array1.length;
        while (--i >= 0) {
            char array1Value = array1[i];
            char array2Value = array2[i];
            if (array1Value == array2Value || array1Value >= 'a' && array1Value <= 'z' && array1Value - 32 == array2Value || array2Value >= 'a' && array2Value <= 'z' && array2Value - 32 == array1Value) continue;
            return false;
        }
        return true;
    }

    public static char[] concat(char[][] arrays) {
        int nbArrays = arrays.length;
        int resLength = 0;
        int i = nbArrays;
        while (--i >= 0) {
            resLength += arrays[i].length;
        }
        char[] res = new char[resLength];
        int resOffset = 0;
        for (int i2 = 0; i2 < nbArrays; ++i2) {
            System.arraycopy(arrays[i2], 0, res, resOffset, arrays[i2].length);
            resOffset += arrays[i2].length;
        }
        return res;
    }

    public static int skipWhiteSpaces(char[] chars, int index) {
        while (Character.isWhitespace(chars[index])) {
            ++index;
        }
        return index;
    }

    public static int skipWhiteSpacesBack(char[] chars, int index) {
        while (Character.isWhitespace(chars[--index])) {
        }
        return index + 1;
    }

    public static int skipNonWhiteSpaces(char[] chars, int index) {
        while (!Character.isWhitespace(chars[index])) {
            ++index;
        }
        return index;
    }

    public static int skipNonLineSeparator(char[] chars, int index) {
        int length = chars.length;
        while (index < length) {
            char ch = chars[index];
            if (ch == '\n' || ch == '\r') {
                return index;
            }
            ++index;
        }
        return length;
    }

    public static char[] toJNIEncodingScheme(char[] name) {
        return ArrayOfChars.toJNIEncodingScheme(name, 0, name.length);
    }

    public static char[] toJNIEncodingScheme(char[] name, int start, int end) {
        int nameLength = end - start;
        char[] result = new char[nameLength * 6];
        int ptr = -1;
        int i = start - 1;
        block9: while (++i < end) {
            int l2;
            char c = name[i];
            switch (c) {
                case '_': {
                    result[++ptr] = 95;
                    result[++ptr] = 49;
                    continue block9;
                }
                case ';': {
                    result[++ptr] = 95;
                    result[++ptr] = 50;
                    continue block9;
                }
                case '[': {
                    result[++ptr] = 95;
                    result[++ptr] = 51;
                    continue block9;
                }
                case '<': {
                    result[++ptr] = 95;
                    result[++ptr] = 52;
                    continue block9;
                }
                case '>': {
                    result[++ptr] = 95;
                    result[++ptr] = 53;
                    continue block9;
                }
                case '.': {
                    result[++ptr] = 95;
                    result[++ptr] = 54;
                    continue block9;
                }
                case '-': {
                    result[++ptr] = 95;
                    result[++ptr] = 55;
                    continue block9;
                }
            }
            if (c <= '\u007f') {
                result[++ptr] = c;
                continue;
            }
            result[++ptr] = 95;
            result[++ptr] = 48;
            char[] toHex = Integer.toHexString(c).toCharArray();
            int j = l2 = toHex.length;
            while (++j <= 4) {
                result[++ptr] = 48;
            }
            int toHexPtr = -1;
            while (++toHexPtr < l2) {
                result[++ptr] = toHex[toHexPtr];
            }
        }
        char[] cArray = result;
        result = new char[++ptr];
        System.arraycopy(cArray, 0, result, 0, ptr);
        return result;
    }

    public static char[] fromJNIEncodingScheme(char[] name) {
        return ArrayOfChars.fromJNIEncodingScheme(name, 0, name.length);
    }

    public static char[] fromJNIEncodingScheme(char[] name, int start, int end) {
        int previousLength = end - start;
        char[] result = new char[previousLength];
        int ptr = -1;
        int i = start;
        while (i < end) {
            char c;
            if ((c = name[i++]) == '_') {
                if (i == end) {
                    return null;
                }
                char next = name[i++];
                switch (next) {
                    case '0': {
                        int unicodeAsInt;
                        if (i + 4 > end) {
                            return null;
                        }
                        try {
                            unicodeAsInt = Integer.parseInt(new String(name).substring(i, i + 4), 16);
                        }
                        catch (NumberFormatException e) {
                            return null;
                        }
                        i += 4;
                        result[++ptr] = (char)unicodeAsInt;
                        break;
                    }
                    case '1': {
                        result[++ptr] = 95;
                        break;
                    }
                    case '2': {
                        result[++ptr] = 59;
                        break;
                    }
                    case '3': {
                        result[++ptr] = 91;
                        break;
                    }
                    case '4': {
                        result[++ptr] = 60;
                        break;
                    }
                    case '5': {
                        result[++ptr] = 62;
                        break;
                    }
                    case '6': {
                        result[++ptr] = 46;
                        break;
                    }
                    case '7': {
                        result[++ptr] = 45;
                        break;
                    }
                    default: {
                        result[++ptr] = next;
                        break;
                    }
                }
                continue;
            }
            result[++ptr] = c;
        }
        int length = ptr + 1;
        char[] cArray = result;
        result = new char[length];
        System.arraycopy(cArray, 0, result, 0, length);
        return result;
    }
}

