/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.tools;

public abstract class ArrayOfBytes {
    public static int parseInt(byte[] chars) {
        return ArrayOfBytes.parseInt(chars, 0, chars.length);
    }

    public static int parseInt(byte[] chars, int offset, int length) {
        int i = offset - 1;
        int value = 0;
        length += offset;
        while (++i < length) {
            value = value * 10 + (chars[i] - 48);
        }
        return value;
    }

    public static int firstIndexOf(byte[] chars, byte c) {
        return ArrayOfBytes.firstIndexOf(chars, 0, c);
    }

    public static int firstIndexOf(byte[] chars, int fromPtr, byte c) {
        int i = fromPtr - 1;
        int lg = chars.length;
        while (++i < lg) {
            if (chars[i] != c) continue;
            return i;
        }
        return -1;
    }

    public static void hardReplace(byte[] array, byte c1, byte c2) {
        int i = array.length;
        while (--i >= 0) {
            if (array[i] != c1) continue;
            array[i] = c2;
        }
    }

    public static boolean startWith(byte[] array, byte[] start) {
        return ArrayOfBytes.isSubArray(array, start) == 0;
    }

    public static int isSubArray(byte[] array, byte[] subarray) {
        if (array == null || subarray == null) {
            return -1;
        }
        int subarraylength = subarray.length;
        if (subarraylength == 0) {
            return 0;
        }
        int index = -1;
        int maxIndex = array.length - subarraylength;
        byte c = subarray[0];
        byte[] chars = array;
        while (++index <= maxIndex) {
            if (chars[index] != c) continue;
            int i = subarraylength;
            int j = index + i;
            while (i > 0 && chars[--j] == subarray[--i]) {
            }
            if (i != 0) continue;
            return index;
        }
        return -1;
    }

    public static int lastIndexOf(byte[] chars, byte c) {
        int i = chars.length;
        while (--i >= 0) {
            if (chars[i] != c) continue;
            return i;
        }
        return -1;
    }

    public static byte[][] slices(byte[] chars, byte c) {
        int start;
        int length = chars.length;
        int[] positions = new int[length];
        int pos = length;
        int i = length;
        while (--i >= 0) {
            if (chars[i] != c) continue;
            positions[--pos] = i;
        }
        int slicesLength = 1 + length - pos;
        if (slicesLength == 1) {
            return new byte[][]{chars};
        }
        byte[][] slices = new byte[slicesLength][];
        int slicesIndex = 0;
        int lengthSlice = positions[pos];
        slices[0] = new byte[lengthSlice];
        System.arraycopy(chars, 0, slices[0], 0, lengthSlice);
        while (++pos < length) {
            start = positions[pos - 1] + 1;
            lengthSlice = positions[pos] - start;
            slices[++slicesIndex] = new byte[lengthSlice];
            System.arraycopy(chars, start, slices[++slicesIndex], 0, lengthSlice);
        }
        start = positions[pos - 1] + 1;
        lengthSlice = length - start;
        slices[++slicesIndex] = new byte[lengthSlice];
        System.arraycopy(chars, start, slices[++slicesIndex], 0, lengthSlice);
        return slices;
    }

    public static boolean equals(byte[] array1, byte[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        int i = array1.length;
        while (--i >= 0) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIgnoreCase(byte[] array1, byte[] array2) {
        if (array1.length != array2.length) {
            return false;
        }
        int i = array1.length;
        while (--i >= 0) {
            byte array1Value = array1[i];
            byte array2Value = array2[i];
            if (array1Value == array2Value || array1Value >= 97 && array1Value <= 122 && array1Value - 32 == array2Value || array2Value >= 97 && array2Value <= 122 && array2Value - 32 == array1Value) continue;
            return false;
        }
        return true;
    }
}

