/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.tools;

import com.is2t.tools.ArrayOfArrayOfChar;

public class ArrayOfArrayOfCharsToIntTable {
    char[][][] keys;
    int keysPtr = -1;
    int[][] entries;
    static final int Threshold = 21;
    static final int DefaultSize = 500;

    public ArrayOfArrayOfCharsToIntTable() {
        this(500, 24);
    }

    public ArrayOfArrayOfCharsToIntTable(int keysSize, int entriesSize) {
        this.keys = new char[keysSize][][];
        this.entries = new int[entriesSize][];
        int i = entriesSize;
        while (--i >= 0) {
            this.entries[i] = new int[21];
            this.entries[i][0] = 1;
        }
    }

    public void addKey(char[][] key) {
        try {
            this.keys[++this.keysPtr] = key;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            char[][][] cArrayArray = new char[this.keysPtr * 2][][];
            this.keys = cArrayArray;
            System.arraycopy(this.keys, 0, cArrayArray, 0, this.keysPtr);
            this.keys[this.keysPtr] = key;
        }
    }

    public int at(char[][] key) {
        int hash = 0;
        int length = key.length;
        while (--length >= 0) {
            hash += key[length].hashCode();
        }
        int[] values = this.entries[hash = (hash & Integer.MAX_VALUE) % this.entries.length];
        if (values == null) {
            return 0;
        }
        int i = values[0];
        while (--i >= 1) {
            if (!ArrayOfArrayOfChar.equalsIntern(this.keys[values[--i]], key)) continue;
            return values[i + 1];
        }
        return 0;
    }

    public int at(char[][] keyH, char[] keyL) {
        int hash = 0;
        int length = keyH.length;
        while (--length >= 0) {
            hash += keyH[length].hashCode();
        }
        hash += keyL.hashCode();
        int[] values = this.entries[hash = (hash & Integer.MAX_VALUE) % this.entries.length];
        if (values == null) {
            return 0;
        }
        int i = values.length;
        while (--i >= 1) {
            if (!ArrayOfArrayOfChar.equalsIntern(this.keys[values[--i]], keyH, keyL)) continue;
            return values[i + 1];
        }
        return 0;
    }

    public void atPut(char[][] keyH, char[] keyL, int value) {
        int length;
        int hash = 0;
        int keyHl = length = ((char[][])keyH).length;
        while (--length >= 0) {
            hash += keyH[length].hashCode();
        }
        hash += keyL.hashCode();
        hash = (hash & Integer.MAX_VALUE) % this.entries.length;
        int vl = 0;
        int[] values = this.entries[hash];
        int i = vl = values[0];
        while (--i >= 1) {
            if (!ArrayOfArrayOfChar.equalsIntern(this.keys[values[--i]], keyH, keyL)) continue;
            values[i + 1] = value;
            return;
        }
        char[][] cArray = keyH;
        char[][] cArrayArray = new char[keyHl + 1][];
        keyH = cArrayArray;
        System.arraycopy(cArray, 0, cArrayArray, 0, keyHl);
        keyH[keyHl] = keyL;
        if (vl == 21) {
            this.rehash();
            this.atPut((char[][])keyH, keyL, value);
            return;
        }
        this.addKey((char[][])keyH);
        values[vl] = this.keysPtr;
        values[vl + 1] = value;
        values[0] = vl + 2;
    }

    public void atPut(char[][] key, int value) {
        int hash = 0;
        int length = key.length;
        while (--length >= 0) {
            hash += key[length].hashCode();
        }
        hash = (hash & Integer.MAX_VALUE) % this.entries.length;
        int vl = 0;
        int[] values = this.entries[hash];
        int i = vl = values[0];
        while (--i >= 1) {
            if (!ArrayOfArrayOfChar.equalsIntern(this.keys[values[--i]], key)) continue;
            values[i + 1] = value;
            return;
        }
        if (vl == 21) {
            this.rehash();
            this.atPut(key, value);
            return;
        }
        this.addKey(key);
        values[vl] = this.keysPtr;
        values[vl + 1] = value;
        values[0] = vl + 2;
    }

    public char[][][] keys() {
        int ni = this.keysPtr + 1;
        char[][][] newKeys = new char[ni][][];
        newKeys = new char[ni][][];
        System.arraycopy(this.keys, 0, newKeys, 0, ni);
        return newKeys;
    }

    public void rehash() {
        boolean needRehash;
        do {
            needRehash = false;
            int[][] oldEntries = this.entries;
            int entriesLength = this.entries.length * 2;
            this.entries = new int[entriesLength][];
            int i = entriesLength;
            while (--i >= 0) {
                this.entries[i] = new int[21];
                this.entries[i][0] = 1;
            }
            i = oldEntries.length;
            while (--i >= 0) {
                int[] oldValues = oldEntries[i];
                int j = oldValues[0];
                while (--j >= 1) {
                    int hash = 0;
                    int keyAsInt = oldValues[--j];
                    char[][] key = this.keys[keyAsInt];
                    int length = key.length;
                    while (--length >= 0) {
                        hash += key[length].hashCode();
                    }
                    int[] values = this.entries[hash = (hash & Integer.MAX_VALUE) % entriesLength];
                    length = values[0];
                    if (length == values.length) {
                        needRehash = true;
                        int[] nArray = values;
                        values = new int[length + 2];
                        this.entries[hash] = values;
                        System.arraycopy(nArray, 0, values, 0, length);
                    }
                    values[length] = keyAsInt;
                    values[length + 1] = oldValues[j + 1];
                    values[0] = values[0] + 2;
                }
            }
        } while (needRehash);
    }
}

