/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.serialsockettransmitter;

import com.is2t.product.Options;
import java.io.PrintStream;

public class SerialToSocketTransmitterOptions
extends Options {
    public static final int InvalidSerialOptionValue = -1;
    public static final int DefaultBaudrate = 115200;
    public static final int DefaultDataBits = 8;
    public static final int DefaultStopBits = 1;
    public static final String DefaultConnectorClassname = "com.is2t.io.comm.ECOMConnector";
    public static final String ParityNone = "none";
    public static final String ParityOdd = "odd";
    public static final String ParityEven = "even";
    public static final String DefaultParity = "none";
    public String connectorClassname = "com.is2t.io.comm.ECOMConnector";
    public String port;
    public int baudrate = 115200;
    public int databits = 8;
    public int stopbits = 1;
    public String parity = "none";
    public String host;
    public int hostPort;

    @Override
    public void printUsage(PrintStream out) {
        super.printUsage(out);
        out.print("-connector classname\n\tconnector to use (by default use com.is2t.io.comm.ECOMConnector)\n");
        out.print("-port portId\n\tport id to use (by default take the first found)\n");
        out.print("-baudrate rate\n\tserial baudrate, by default 115200\n");
        out.print("-databits bits\n\tdatabits (5|6|7|8), by default 8\n");
        out.print("-stopbits bits\n\tstopbits (0|1|3 for (1_5)), by default 1\n");
        out.print("-parity value\n\tnone|odd|even, by default none\n");
        out.print("-host addr\n\tHost address\n");
        out.print("-hostPort port\n\tHost port\n");
    }

    @Override
    public boolean setOneArgumentOption(String option, String argument) {
        if (super.setOneArgumentOption(option, argument)) {
            return true;
        }
        if (option.equals("-port")) {
            this.port = argument;
            return true;
        }
        if (option.equals("-baudrate")) {
            try {
                this.baudrate = Integer.parseInt(argument);
            }
            catch (NumberFormatException e) {
                this.baudrate = -1;
            }
            return true;
        }
        if (option.equals("-databits")) {
            try {
                this.databits = Integer.parseInt(argument);
            }
            catch (NumberFormatException e) {
                this.databits = -1;
            }
            return true;
        }
        if (option.equals("-stopbits")) {
            try {
                this.stopbits = Integer.parseInt(argument);
            }
            catch (NumberFormatException e) {
                this.stopbits = -1;
            }
            return true;
        }
        if (option.equals("-parity")) {
            this.parity = argument;
            return true;
        }
        if (option.equals("-connector")) {
            this.connectorClassname = argument;
            return true;
        }
        if (option.equals("-hostPort")) {
            try {
                this.hostPort = Integer.parseInt(argument);
            }
            catch (NumberFormatException e) {
                this.hostPort = -1;
            }
            return true;
        }
        if (option.equals("-host")) {
            this.host = argument;
            return true;
        }
        return false;
    }
}

