/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.serialsockettransmitter;

import com.is2t.product.Options;
import com.is2t.product.Product;
import com.is2t.serialsockettransmitter.SerialConsummer;
import com.is2t.serialsockettransmitter.SerialToSocketTransmitterOptions;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;

public class SerialToSocketTransmitter
extends Product {
    private boolean stop = false;

    @Override
    public void initialize() {
    }

    @Override
    public Options newOptions() {
        return new SerialToSocketTransmitterOptions();
    }

    @Override
    public void run() {
        OutputStream os = null;
        SerialToSocketTransmitterOptions options = (SerialToSocketTransmitterOptions)this.options;
        try {
            SerialConsummer serialCons = new SerialConsummer(options.connectorClassname, options.port, options.baudrate, options.databits, options.stopbits, options.parity);
            serialCons.open();
            new Thread(serialCons).start();
            if (options.host == null) {
                ServerSocket server = new ServerSocket(options.hostPort);
                this.verbose(1, "Waiting for connections on port " + options.hostPort + ".");
                while (!this.stop) {
                    Socket client = server.accept();
                    this.verbose(1, "New client connected.");
                    os = client.getOutputStream();
                    serialCons.setOS(os);
                }
                serialCons.close();
            } else {
                this.verbose(1, "Connect to host " + options.host + "...");
                Socket socket = new Socket(options.host, options.hostPort);
                this.verbose(1, "Connection established.");
                os = socket.getOutputStream();
                serialCons.setOS(os);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        this.stop = true;
    }
}

