/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.serialsockettransmitter;

import com.is2t.io.Connection;
import com.is2t.io.Connector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class SerialConsummer
implements Runnable {
    public Connection connection;
    public String serialConnectorClass;
    public String port;
    public int baudrate;
    public int dataBits;
    public int stopBits;
    public String parity;
    public OutputStream os;
    public InputStream is;
    private boolean stop = false;

    public SerialConsummer(String serialConnectorClass, String port, int baudrate, int dataBits, int stopBits, String parity) {
        this.serialConnectorClass = serialConnectorClass;
        this.port = port;
        this.baudrate = baudrate;
        this.dataBits = dataBits;
        this.stopBits = stopBits;
        this.parity = parity;
    }

    public void open() throws IOException {
        this.connection = Connector.open(this.serialConnectorClass + ":" + this.port + ',' + this.baudrate + ',' + this.dataBits + ',' + this.stopBits + ',' + this.parity);
        this.is = this.connection.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!this.stop) {
                int readBytes = -1;
                while ((readBytes = this.is.read()) != -1) {
                    this.transmitData(readBytes);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                this.os.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void close() throws IOException {
        this.is.close();
        this.connection.close();
    }

    public synchronized void setOS(OutputStream os) {
        this.os = os;
    }

    public synchronized void transmitData(int data) {
        try {
            if (this.os != null) {
                this.os.write(data);
                this.os.flush();
            }
        }
        catch (IOException e) {
            try {
                this.os.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }
}

