/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.product.error;

public abstract class ProductError
extends RuntimeException {
    public int kind;
    public String[] parts;

    public String getErrorMessage() {
        return ProductError.messageAt(this.kind, this.parts, this.getMessages());
    }

    public abstract String[] getMessages();

    public boolean isFatal() {
        return true;
    }

    public boolean isWarning() {
        return false;
    }

    public String outputName() {
        String errorKindPrefix = this.getCategory();
        return (errorKindPrefix == null ? "" : errorKindPrefix + " ") + (this.isWarning() ? "WARNING" : "ERROR");
    }

    protected String getCategory() {
        return null;
    }

    public int startPosition() {
        return -1;
    }

    public int stopPosition() {
        return -1;
    }

    public static String messageAt(int index, String[] parts, String[] messages) {
        char[] message;
        try {
            message = messages[index].toCharArray();
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return "--error--";
        }
        int i = 0;
        int partI = -1;
        int length = message.length;
        while (i < length) {
            if (message[i] == '\\') {
                char[] part;
                try {
                    partI = Integer.parseInt(new String(new char[]{message[i + 1]}));
                }
                catch (NumberFormatException ex) {
                    partI = 999999;
                }
                try {
                    part = parts[partI].toCharArray();
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    part = new char[]{'?', '?'};
                }
                int partLength = part.length;
                char[] newMessage = new char[length - 2 + partLength];
                System.arraycopy(message, 0, newMessage, 0, i);
                System.arraycopy(part, 0, newMessage, i, partLength);
                System.arraycopy(message, i + 2, newMessage, i + partLength, newMessage.length - i - partLength);
                length = length - 2 + partLength;
                i += partLength;
                message = newMessage;
                continue;
            }
            ++i;
        }
        return "[M" + index + "] - " + String.valueOf(message);
    }
}

