/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.product.error;

import com.is2t.product.error.ErrorDescription;
import com.is2t.product.error.ErrorHandler;
import com.is2t.product.error.ProductError;
import com.is2t.tools.SimpleVector;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ErrorTaskContainer {
    private SimpleVector errorDescriptions = new SimpleVector();
    public boolean omitWarnings;

    public ErrorDescription createErrorDescription() {
        ErrorDescription error = new ErrorDescription();
        return error;
    }

    public void addConfiguredErrorDescription(ErrorDescription error) {
        if (error.category == null) {
            throw new RuntimeException("Missing error category");
        }
        if (error.kind == -1) {
            throw new RuntimeException("Missing error kind");
        }
        this.errorDescriptions.add(error);
    }

    public void setOmitWarnings(boolean value) {
        this.omitWarnings = value;
    }

    public void outputError(ErrorHandler errorHandler) {
        Object[] expectedErrors = new ErrorDescription[this.errorDescriptions.nbObjects()];
        this.errorDescriptions.copyToArray(expectedErrors);
        int expectedErrorPtr = -1;
        int nbErrors = errorHandler.currentNotification + 1;
        ProductError[] errors = errorHandler.allKindOfNotifications;
        char[][] sources = errorHandler.sources;
        String[] filenames = errorHandler.filenames;
        int i = -1;
        while (++i < nbErrors) {
            Object expectedError;
            ProductError error = errors[i];
            errorHandler.dump(System.out, error, i, sources[i], filenames[i]);
            try {
                expectedError = expectedErrors[++expectedErrorPtr];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                if (this.omitWarnings) {
                    int ptr = nbErrors;
                    while (--ptr >= expectedErrorPtr) {
                        if (!errors[ptr].isFatal()) continue;
                        throw new RuntimeException("Not enough declared expected errors");
                    }
                    return;
                }
                throw new RuntimeException("Not enough declared expected errors");
            }
            if (!((ErrorDescription)expectedError).category.equals(error.outputName())) {
                throw new RuntimeException("Invalid Error Category (" + error.outputName() + ", expected " + ((ErrorDescription)expectedError).category + ")");
            }
            if (((ErrorDescription)expectedError).kind != error.kind) {
                if (this.omitWarnings && error.isWarning()) {
                    --expectedErrorPtr;
                    continue;
                }
                throw new RuntimeException("Invalid Error Kind (" + error.kind + ", expected " + ((ErrorDescription)expectedError).kind + ")");
            }
            if (((ErrorDescription)expectedError).errorName != null && !error.outputName().equalsIgnoreCase(((ErrorDescription)expectedError).errorName)) {
                throw new RuntimeException("Invalid error name: " + ((ErrorDescription)expectedError).errorName + ", expected " + error.outputName());
            }
            if (((ErrorDescription)expectedError).matchMessage == null) continue;
            ByteArrayOutputStream stream = new ByteArrayOutputStream(1000);
            PrintStream ps = new PrintStream(stream);
            errorHandler.dump(ps, error, i, sources[i], filenames[i]);
            Pattern p = Pattern.compile(((ErrorDescription)expectedError).matchMessage, 40);
            Matcher m = p.matcher(new String(stream.toByteArray()));
            if (m.matches()) continue;
            throw new RuntimeException("Previous error does not match: " + ((ErrorDescription)expectedError).matchMessage);
        }
        if (expectedErrorPtr + 1 != expectedErrors.length) {
            throw new RuntimeException("Too many declared expected errors");
        }
    }
}

