/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.product.error;

import com.is2t.product.error.FileLocationInfos;
import com.is2t.product.error.IErrorHandler;
import com.is2t.product.error.ProductError;
import com.is2t.tools.ObjectToObjectTable;
import com.is2t.tools.Search;
import java.io.OutputStream;
import java.io.PrintStream;

public class ErrorHandler
implements IErrorHandler {
    public ProductError[] allKindOfNotifications;
    public char[][] sources;
    public String[] filenames;
    public int currentNotification;
    public int errorCounter;
    public int warningCounter;
    private char[] errorSource;
    private String errorSourceFilename;
    private ObjectToObjectTable sourceLines;

    public ErrorHandler() {
        int Size = 10;
        this.allKindOfNotifications = new ProductError[Size];
        this.sources = new char[Size][];
        this.filenames = new String[Size];
        this.currentNotification = -1;
        this.sourceLines = new ObjectToObjectTable();
        this.warningCounter = 0;
        this.errorCounter = 0;
    }

    public void addErrorOnFile(String filename, ProductError ex) {
        this.addErrorOnSource(null, filename, ex);
    }

    public void addErrorOn(FileLocationInfos location, ProductError ex) {
        this.addErrorOnSource(location.text, location.filename, ex);
    }

    @Override
    public void addErrorOnSource(char[] source, String filename, ProductError ex) {
        try {
            this.allKindOfNotifications[++this.currentNotification] = ex;
        }
        catch (ArrayIndexOutOfBoundsException outEx) {
            this.allKindOfNotifications = new ProductError[this.currentNotification + 100];
            System.arraycopy(this.allKindOfNotifications, 0, this.allKindOfNotifications, 0, this.currentNotification);
            char[][] cArrayArray = new char[this.allKindOfNotifications.length][];
            this.sources = cArrayArray;
            System.arraycopy(this.sources, 0, cArrayArray, 0, this.currentNotification);
            this.filenames = new String[this.allKindOfNotifications.length];
            System.arraycopy(this.filenames, 0, this.filenames, 0, this.currentNotification);
            this.allKindOfNotifications[this.currentNotification] = ex;
        }
        this.sources[this.currentNotification] = source;
        this.filenames[this.currentNotification] = filename;
        if (ex.isWarning()) {
            ++this.warningCounter;
        } else {
            ++this.errorCounter;
        }
    }

    public void addNoFile(ProductError ex) {
        this.addErrorOnSource(null, null, ex);
    }

    @Override
    public void add(ProductError ex) {
        this.addErrorOnSource(this.errorSource, this.errorSourceFilename, ex);
    }

    public void dump(OutputStream output, ProductError ex, int errorIndex, char[] source, String filename) {
        this.dump(new PrintStream(output), ex, errorIndex, source, filename);
    }

    public void dump(PrintStream output, ProductError ex, int errorIndex, char[] source, String filename) {
        output.println(errorIndex + " : " + ex.outputName() + " :");
        output.println(ex.getErrorMessage());
        output.println(this.faultyPieceOfCode(ex.startPosition(), ex.stopPosition(), source, filename));
    }

    public String faultyPieceOfCode(int startPosition, int stopPosition, char[] source, String filename) {
        if (stopPosition < startPosition) {
            stopPosition = startPosition;
        }
        if (source == null) {
            if (filename == null) {
                return "";
            }
            return "(in " + filename + ")";
        }
        if (startPosition < 0) {
            return "";
        }
        int line = 0;
        try {
            int relativeStopPosition;
            char[] theLine;
            int relativeStartPosition;
            int[] lines = this.lineTerminators(source);
            int nbLines = lines.length;
            line = ErrorHandler.searchLines(startPosition, lines) - 1;
            if (line == -1) {
                relativeStartPosition = startPosition;
                if (nbLines == 0) {
                    theLine = source;
                    relativeStopPosition = stopPosition;
                } else {
                    int positionEndOfLine = lines[0];
                    theLine = new char[positionEndOfLine];
                    System.arraycopy(source, 0, theLine, 0, positionEndOfLine);
                    relativeStopPosition = stopPosition >= positionEndOfLine ? positionEndOfLine - 1 : stopPosition;
                }
            } else {
                int positionStartLine = lines[line] + 1;
                relativeStartPosition = startPosition - positionStartLine;
                if (line == nbLines - 1) {
                    relativeStopPosition = stopPosition - positionStartLine;
                    int nbchars = source.length - lines[nbLines - 1] - 1;
                    theLine = new char[nbchars];
                    System.arraycopy(source, lines[nbLines - 1] + 1, theLine, 0, nbchars);
                } else {
                    int positionEndOfLine = lines[line + 1];
                    relativeStopPosition = (stopPosition >= positionEndOfLine ? positionEndOfLine - 1 : stopPosition) - positionStartLine;
                    int nbchars = positionEndOfLine - positionStartLine;
                    theLine = new char[nbchars];
                    System.arraycopy(source, positionStartLine, theLine, 0, nbchars);
                }
            }
            if (theLine.length > 0 && theLine[theLine.length - 1] == '\r') {
                int length = theLine.length;
                char[] cArray = theLine;
                theLine = new char[theLine.length - 1];
                System.arraycopy(cArray, 0, theLine, 0, theLine.length);
                if (relativeStopPosition == length - 1) {
                    --relativeStopPosition;
                }
            }
            char[] underLine = new char[relativeStopPosition + 1];
            int c = relativeStopPosition + 1;
            while (--c >= relativeStartPosition) {
                if (theLine[c] == '\t') {
                    underLine[c] = 9;
                    continue;
                }
                underLine[c] = 94;
            }
            c = relativeStartPosition;
            while (--c >= 0) {
                if (theLine[c] == '\t') {
                    underLine[c] = 9;
                    continue;
                }
                underLine[c] = 32;
            }
            return "(line " + (line + 2) + " of " + filename + ")\n" + new String(theLine) + "\n" + new String(underLine);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return "(line " + (line + 2) + " of " + filename + ")\n..........";
        }
    }

    public int[] lineTerminators(char[] source) {
        Object result = this.sourceLines.at(source);
        if (result != null) {
            return (int[])result;
        }
        int length = source.length;
        int[] lines = new int[length / 10];
        int linesPtr = -1;
        int i = -1;
        int previousCR = -2;
        while (++i < length) {
            char c = source[i];
            if (c == '\n') {
                if (previousCR == i - 1) {
                    lines[linesPtr] = i;
                    continue;
                }
                try {
                    lines[++linesPtr] = i;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    int[] nArray = lines;
                    lines = new int[linesPtr + 500];
                    System.arraycopy(nArray, 0, lines, 0, linesPtr);
                    lines[linesPtr] = i;
                }
                continue;
            }
            if (c != '\r') continue;
            previousCR = i;
            try {
                lines[++linesPtr] = i;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                int[] nArray = lines;
                lines = new int[linesPtr + 500];
                System.arraycopy(nArray, 0, lines, 0, linesPtr);
                lines[linesPtr] = i;
            }
        }
        int[] nArray = lines;
        lines = new int[linesPtr + 1];
        System.arraycopy(nArray, 0, lines, 0, linesPtr + 1);
        this.sourceLines.atPut(source, lines);
        return lines;
    }

    @Override
    public boolean outputError() {
        return this.outputError(System.out);
    }

    public boolean outputError(PrintStream out) {
        if (this.currentNotification == -1) {
            return false;
        }
        boolean fatal = false;
        int dumpIndex = 0;
        for (int i = 0; i <= this.currentNotification; ++i) {
            ProductError error = this.allKindOfNotifications[i];
            this.dump(out, error, ++dumpIndex, this.sources[i], this.filenames[i]);
            fatal |= this.allKindOfNotifications[i].isFatal();
        }
        this.currentNotification = -1;
        return fatal;
    }

    @Override
    public boolean hasError() {
        int i = this.currentNotification + 1;
        while (--i >= 0) {
            if (!this.allKindOfNotifications[i].isFatal()) continue;
            return true;
        }
        return false;
    }

    public static int searchLines(int position, int[] lineTerminators) {
        int length = lineTerminators.length;
        if (length == 0) {
            return 0;
        }
        int line = Search.orderedIntArrayLessThanEqual(lineTerminators, 0, length - 1, position);
        if (line == -2) {
            return 0;
        }
        if (line == -1) {
            return length;
        }
        return line + 1;
    }

    public void errorSource(String filename) {
        this.errorSource(null, filename);
    }

    public void errorSource(char[] s, String filename) {
        this.errorSource = s;
        this.errorSourceFilename = filename;
    }

    public String errorSourceFilename() {
        return this.errorSourceFilename;
    }

    public char[] errorSource() {
        return this.errorSource;
    }

    public int oneBasedLine(char[] source, int position) {
        int[] lines = this.lineTerminators(source);
        return ErrorHandler.searchLines(position, lines) + 1;
    }
}

