/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.product;

class ProgressTask {
    public ProgressTask parent;
    public ProgressTask[] subTasks;
    public int currentTaskPtr;

    public ProgressTask(ProgressTask parent) {
        this.parent = parent;
    }

    public void setNbSubTasks(int nbSubTasks) {
        this.subTasks = new ProgressTask[nbSubTasks];
        int i = nbSubTasks;
        while (--i >= 0) {
            this.subTasks[i] = new ProgressTask(this);
        }
    }

    public void nextCurrentTask() {
        ++this.currentTaskPtr;
    }

    public int currentPercentDone() {
        return this.currentPercentDoneRec(0, 1);
    }

    private int currentPercentDoneRec(int nbDoneSubLevel, int nbTasksSubLevel) {
        int nbDone = this.currentTaskPtr * nbTasksSubLevel + nbDoneSubLevel;
        int nbTasks = nbTasksSubLevel * this.subTasks.length;
        if (this.parent == null) {
            return nbDone * 100 / nbTasks;
        }
        return this.parent.currentPercentDoneRec(nbDone, nbTasks);
    }

    public ProgressTask currentSubTask() {
        return this.subTasks[this.currentTaskPtr];
    }

    public boolean done() {
        return this.currentTaskPtr == this.subTasks.length;
    }
}

