/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.product;

import com.is2t.product.Options;
import com.is2t.product.Product;
import com.is2t.product.error.ErrorHandler;
import com.is2t.product.error.ErrorTaskContainer;
import com.is2t.product.error.InternalError;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public abstract class ProductTask
extends Task {
    protected Product product = this.newProduct();
    private ErrorTaskContainer errorContainer;

    public ProductTask() {
        this.product.initialize();
    }

    public Options getOptions() {
        return this.product.getOptions();
    }

    public void setVerboseLevel(int level) {
        if (level < 0) {
            level = 0;
        } else if (level > 9) {
            level = 9;
        }
        this.getOptions().setVerboseLevel(level);
    }

    public void setSanityCheck(boolean b) {
        this.getOptions().setSanityCheck(b);
    }

    public void execute() {
        ErrorHandler errorHandler = this.product.getErrorHandler();
        try {
            this.product.run();
        }
        catch (Throwable e) {
            if (this.getOptions().sanityCheck) {
                e.printStackTrace();
            }
            errorHandler.addNoFile(new InternalError().internalLimit(-1));
        }
        this.outputError();
    }

    public void outputError() {
        ErrorHandler errorHandler = this.product.getErrorHandler();
        if (this.errorContainer == null) {
            boolean hasErrors = errorHandler.hasError();
            errorHandler.outputError();
            if (hasErrors) {
                throw new BuildException("Terminated with errors");
            }
        } else {
            this.errorContainer.outputError(errorHandler);
        }
    }

    protected abstract Product newProduct();

    public void addConfiguredErrorTaskContainer(ErrorTaskContainer errorContainer) {
        this.errorContainer = errorContainer;
    }

    public Product getProduct() {
        return this.product;
    }
}

