/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.product;

import com.is2t.product.Options;
import com.is2t.product.ProgressIndicator;
import com.is2t.product.error.ErrorHandler;
import com.is2t.product.error.InternalError;
import com.is2t.product.error.ProductError;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public abstract class Product {
    protected Options options = this.newOptions();
    protected ProgressIndicator progressIndicator;
    protected ErrorHandler errorHandler = this.newErrorHandler();
    private static final String ProductFilename = "product.properties";
    private static final String PropertyProductName = "product.printable.name";
    private static final String PropertyProductVersion = "product.version";
    private String version;

    public Product() {
        this.progressIndicator = new ProgressIndicator(1);
    }

    public void batchRun(String[] commandLine) {
        boolean sanityCheck = false;
        int i = commandLine.length;
        while (--i >= 0) {
            if (!commandLine[i].equals("-sanityCheck") && !commandLine[i].equals("-istSpecialMode")) continue;
            sanityCheck = true;
            break;
        }
        boolean endsWithErrors = false;
        if (sanityCheck) {
            endsWithErrors = this.batchRun0(commandLine);
        } else {
            try {
                endsWithErrors = this.batchRun0(commandLine);
            }
            catch (Throwable e) {
                System.out.println(new InternalError().internalLimit(-1).getErrorMessage());
                System.exit(-1);
            }
        }
        if (endsWithErrors) {
            System.exit(1);
        }
    }

    protected void initialize() {
    }

    protected abstract Options newOptions();

    protected ErrorHandler newErrorHandler() {
        return new ErrorHandler();
    }

    public abstract void run();

    protected void batchRunIsDone() {
    }

    private boolean batchRun0(String[] commandLine) {
        this.initialize();
        try {
            if (!this.options.setOptionsFrom(commandLine)) {
                this.abortOnError();
                return true;
            }
        }
        catch (ProductError e) {
            this.errorHandler.addNoFile(e);
        }
        if (this.errorHandler != null && this.errorHandler.outputError()) {
            this.abortOnError();
            return true;
        }
        this.run();
        boolean endsWithErrors = false;
        if (this.errorHandler != null) {
            endsWithErrors = this.errorHandler.outputError();
        }
        this.batchRunIsDone();
        return endsWithErrors;
    }

    protected void abortOnError() {
        System.out.print(this.productNameAndVersion());
        System.out.println(" - " + this.copyright());
        this.options.printUsage(System.out);
    }

    public String productNameAndVersion() {
        if (this.version != null) {
            return this.version;
        }
        InputStream is = this.getClass().getResourceAsStream(ProductFilename);
        String productName = null;
        String productVersion = null;
        if (is != null) {
            Properties p = new Properties();
            try {
                p.load(is);
            }
            catch (IOException e) {
                // empty catch block
            }
            productName = (String)p.get(PropertyProductName);
            productVersion = (String)p.get(PropertyProductVersion);
        }
        if (productName == null) {
            productName = "Unknown product";
        }
        if (productVersion == null) {
            productVersion = "Unknown version";
        }
        this.version = productName + " - " + productVersion;
        return this.version;
    }

    public String copyright() {
        int yearStart = this.getCopyrightYearStart();
        int yearStop = this.getCopyrightYearStop();
        return "(c) IS2T - " + yearStart + (yearStop != yearStart ? "-" + yearStop : "");
    }

    public int getCopyrightYearStart() {
        return 2004;
    }

    public int getCopyrightYearStop() {
        return 2014;
    }

    public boolean canVerbose(int level, boolean intern) {
        Options options = this.options;
        if (intern) {
            return false;
        }
        return level <= options.verboseLevel;
    }

    public void verbose(int level, String text) {
        this.verbose(level, text, false);
    }

    public void verbose(int level, String text, boolean intern) {
        if (this.canVerbose(level, intern)) {
            System.out.println("INFO: " + text);
        }
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public Options getOptions() {
        return this.options;
    }

    public ProgressIndicator getProgressIndicator() {
        return this.progressIndicator;
    }
}

