/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.product;

import java.io.PrintStream;

public abstract class Options {
    public int verboseLevel;
    public boolean sanityCheck;

    public boolean setOptionsFrom(String[] commandLine) {
        int length = commandLine.length;
        int i = 0;
        while (i < length) {
            String option;
            if (this.isHelpOption(option = commandLine[i++])) {
                return false;
            }
            if (this.setNoArgumentOption(option)) continue;
            if (i < length && this.setOneArgumentOption(option, commandLine[i])) {
                ++i;
                continue;
            }
            this.unknownOption(option);
        }
        return true;
    }

    public boolean setNoArgumentOption(String option) {
        if (option.equals("-verbose")) {
            this.verboseLevel = 1;
            return true;
        }
        if (option.equals("-verbosee")) {
            this.verboseLevel = 2;
            return true;
        }
        if (option.equals("-verboseee")) {
            this.verboseLevel = 3;
            return true;
        }
        if (option.equals("-verboseeee")) {
            this.verboseLevel = 4;
            return true;
        }
        if (option.equals("-verboseeeee")) {
            this.verboseLevel = 5;
            return true;
        }
        if (option.equals("-verboseeeeee")) {
            this.verboseLevel = 6;
            return true;
        }
        if (option.equals("-verboseeeeeee")) {
            this.verboseLevel = 7;
            return true;
        }
        if (option.equals("-verboseeeeeeee")) {
            this.verboseLevel = 8;
            return true;
        }
        if (option.equals("-verboseeeeeeeee")) {
            this.verboseLevel = 9;
            return true;
        }
        if (option.equals("-sanityCheck")) {
            this.setSanityCheck(true);
            return true;
        }
        if (this.isHelpOption(option)) {
            this.printUsage(System.out);
            return true;
        }
        return false;
    }

    public void setSanityCheck(boolean b) {
        this.sanityCheck = b;
    }

    public void setVerboseLevel(int level) {
        this.verboseLevel = level;
    }

    public boolean setOneArgumentOption(String option, String argument) {
        return false;
    }

    public void unknownOption(String arg) {
    }

    public void printUsage(PrintStream out) {
        out.print("-verbose[e....e]\n\textra messages are printed out to the console (add extra e to get more messages)\n");
    }

    private boolean isHelpOption(String option) {
        return option.equals("-h") || option.equals("-help");
    }

    public static String[] splitElements(String option, String separator) {
        return Options.removeEmptyElement(option.split(separator));
    }

    private static String[] removeEmptyElement(String[] strings) {
        int nb = 0;
        for (int i = 0; i < strings.length; ++i) {
            if (strings[i].length() == 0) continue;
            ++nb;
        }
        if (nb == strings.length) {
            return strings;
        }
        String[] stringsWithoutEmpty = new String[nb];
        int ptr = -1;
        for (int i = 0; i < strings.length; ++i) {
            if (strings[i].length() == 0) continue;
            stringsWithoutEmpty[++ptr] = strings[i];
        }
        return stringsWithoutEmpty;
    }

    protected String getInternalOption(String name) {
        return System.getProperty(name);
    }

    protected int getInternalOptionAsInt(String name, int defaultSymboltableNbentries) {
        String value = this.getInternalOption(name);
        if (value == null) {
            return defaultSymboltableNbentries;
        }
        value = value.toLowerCase().trim();
        try {
            if (value.startsWith("0x")) {
                return Integer.parseInt(value.substring(2), 16);
            }
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultSymboltableNbentries;
        }
    }
}

