/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.io.socket;

import com.is2t.io.Connection;
import com.is2t.io.ConnectionFactoryInterface;
import com.is2t.io.exceptions.ConnectionNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class SocketConnection
implements Connection,
ConnectionFactoryInterface {
    private ServerSocket ssocket;
    private Socket socket;
    private int mode;

    @Override
    public Connection open(String commParams, int mode, boolean timeouts) throws IOException {
        boolean isServer;
        this.mode = mode;
        int bindPort = 2020;
        String bindAddress = "";
        String[] params = commParams.split(":");
        if (params.length > 3) {
            throw new ConnectionNotFoundException("invalid url parameters");
        }
        if (!params[0].equalsIgnoreCase("socket")) {
            throw new ConnectionNotFoundException("SocketConnection manage only socket type");
        }
        boolean bl = isServer = params.length != 3;
        if (params.length == 3) {
            bindAddress = params[1];
            try {
                bindPort = Integer.parseInt(params[2]);
            }
            catch (NumberFormatException e) {
                throw new ConnectionNotFoundException("invalid port number");
            }
        }
        if (params.length > 1) {
            try {
                bindPort = Integer.parseInt(params[1]);
            }
            catch (NumberFormatException e) {
                throw new ConnectionNotFoundException("invalid port number");
            }
        }
        if (isServer) {
            this.ssocket = new ServerSocket();
            this.ssocket.setReuseAddress(true);
            this.ssocket.bind(new InetSocketAddress(bindPort));
        } else {
            this.socket = new Socket(bindAddress, bindPort);
        }
        return this;
    }

    public Socket accept(int timeout) throws IOException {
        this.ssocket.setSoTimeout(timeout);
        this.socket = this.ssocket.accept();
        return this.socket;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.mode == 1 || this.mode == 3) {
            return this.socket.getInputStream();
        }
        throw new IOException("Illegal access on READ");
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.mode == 2 || this.mode == 3) {
            return this.socket.getOutputStream();
        }
        throw new IOException("Illegal access on WRITE");
    }

    @Override
    public void close() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            if (this.ssocket != null) {
                this.ssocket.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

