/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.io.file;

import com.is2t.io.Connection;
import com.is2t.io.ConnectionFactoryInterface;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileConnection
implements Connection,
ConnectionFactoryInterface {
    File inputFile;
    FileInputStream inputStream;
    File outputFile;
    FileOutputStream outputStream;
    int mode;

    @Override
    public Connection open(String connectionParams, int mode, boolean timeouts) throws IOException {
        File outputFile;
        this.mode = mode;
        String[] splittedConnectionParams = connectionParams.split(",");
        if (splittedConnectionParams.length != 3 || !splittedConnectionParams[0].equals("file")) {
            throw new IOException("Invalid connection descriptor for FileConnection.");
        }
        String inputFileString = splittedConnectionParams[1];
        String outputFileString = splittedConnectionParams[2];
        File inputFile = new File(inputFileString);
        if (inputFile.exists() && inputFile.isFile()) {
            this.inputFile = inputFile;
        }
        if ((outputFile = new File(outputFileString)).exists() && outputFile.isFile()) {
            this.outputFile = outputFile;
        }
        return this;
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
        if (this.outputStream != null) {
            this.outputStream.close();
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.mode != 1 && this.mode != 3) {
            throw new IOException("Mode does not allow InputStream opening.");
        }
        if (this.inputFile != null) {
            this.inputStream = new FileInputStream(this.inputFile);
            return this.inputStream;
        }
        throw new IOException("File not found.");
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.mode != 2 && this.mode != 3) {
            throw new IOException("Mode does not allow OutputStream opening.");
        }
        if (this.outputFile != null) {
            this.outputStream = new FileOutputStream(this.outputFile);
            return this.outputStream;
        }
        throw new IOException("File not found.");
    }
}

