/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.io;

import com.is2t.io.Connection;
import com.is2t.io.ConnectionFactoryInterface;
import com.is2t.io.exceptions.ConnectionException;
import com.is2t.io.exceptions.ConnectionNotFoundException;
import com.is2t.io.exceptions.UnsupportedCommOperationException;
import java.io.IOException;

public class Connector {
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int READ_WRITE = 3;
    public static final String FACTORY_PACKAGE = "com.is2t.io";

    public static Connection open(String commDescription) throws IOException {
        return Connector.open(commDescription, 3, false);
    }

    public static Connection open(String commDescription, int mode) throws IOException {
        return Connector.open(commDescription, mode, false);
    }

    public static Connection open(String connectionDescriptor, int mode, boolean timeouts) throws IOException {
        Class<?> connectionClass;
        String factoryClassname;
        int to;
        try {
            to = connectionDescriptor.indexOf(58, 0);
            factoryClassname = connectionDescriptor.substring(0, to);
        }
        catch (Exception e) {
            throw new ConnectionNotFoundException("invalid descriptor: " + connectionDescriptor);
        }
        try {
            connectionClass = Class.forName(factoryClassname);
        }
        catch (ClassNotFoundException e1) {
            throw new ConnectionNotFoundException(" class not found :" + e1.getMessage());
        }
        try {
            ConnectionFactoryInterface connectionFactory = (ConnectionFactoryInterface)connectionClass.newInstance();
            return connectionFactory.open(connectionDescriptor.substring(to + 1, connectionDescriptor.length()), mode, timeouts);
        }
        catch (InstantiationException e) {
            throw new UnsupportedCommOperationException(e.getMessage() + "InstantiationException (" + connectionDescriptor + ")");
        }
        catch (IllegalAccessException e) {
            throw new SecurityException();
        }
        catch (IndexOutOfBoundsException e) {
            throw new ConnectionNotFoundException("invalid descriptor (" + connectionDescriptor + ")");
        }
        catch (RuntimeException e) {
            throw new ConnectionException("failed to open serial port");
        }
    }
}

