/*
 * Decompiled with CFR 0.152.
 */
package com.is2t.serialsockettransmitter;

import com.is2t.microej.workbench.extension.Page;
import com.is2t.microej.workbench.extension.PagesResolver;
import com.is2t.microej.workbench.std.launch.ext.ComboOption;
import com.is2t.microej.workbench.std.launch.ext.Description;
import com.is2t.microej.workbench.std.launch.ext.Group;
import com.is2t.microej.workbench.std.launch.ext.ILabel;
import com.is2t.microej.workbench.std.launch.ext.LabelGroup;
import com.is2t.microej.workbench.std.launch.ext.OptionValidator;
import com.is2t.microej.workbench.std.launch.ext.PageContent;
import com.is2t.microej.workbench.std.launch.ext.StringLabel;
import com.is2t.microej.workbench.std.launch.ext.TextFieldOption;
import com.is2t.microej.workbench.std.launch.ext.XHTMLDescription;
import com.is2t.microej.workbench.std.launch.ext.expr.Expression;
import com.is2t.serialsockettransmitter.Messages;

public class SerialToSocketTransmitterPage
implements Page {
    public static final boolean OnLinux = System.getProperty("os.name").toLowerCase().indexOf("win") == -1;
    public static final String[] DEFAULT_BAUDRATES = new String[]{"9600", "38400", "57600", "115200"};
    public static final String DEFAULT_COMM_PORT_LINUX = "/dev/ttyS0";
    public static final String DEFAULT_COMM_PORT_WINDOWS = "COM0";
    public static final int DEFAULT_BAUDRATE_ID = 3;
    public ComboOption baudrate;
    public static final String COMM_PORT = "serail.to.socket.comm.port";
    public static final String COMM_BAUDRATE = "serail.to.socket.comm.baudrate";
    public static final String SERVER_PORT = "serail.to.socket.server.port";
    public static final String DEFAULT_SERVER_PORT = "5555";

    public String getParent() {
        return null;
    }

    public String getName() {
        return Messages.CATEGORY_SERIAL_TO_SOCKET;
    }

    public Description getDescription() {
        return null;
    }

    public PageContent getContent() {
        PageContent[] content = new PageContent[]{this.buildSerialGroup(DEFAULT_BAUDRATES, 3), this.buildPCSocketConnection()};
        return new Group(content, 1);
    }

    private Group buildSerialGroup(String[] baudrateValues, int defaultValueId) {
        String defaultPort = OnLinux ? DEFAULT_COMM_PORT_LINUX : DEFAULT_COMM_PORT_WINDOWS;
        TextFieldOption commPort = new TextFieldOption((ILabel)new StringLabel(Messages.LabelCommPort), COMM_PORT);
        commPort.setInitialValue(defaultPort);
        commPort.setDescription((Description)new XHTMLDescription(Messages.DocumentDescriptionCommPort));
        commPort.setOptionValidator(new OptionValidator(){

            public String getErrorMessage(PageContent option) {
                TextFieldOption t = (TextFieldOption)option;
                String value = t.getSelection().trim();
                if (value.length() == 0) {
                    return Messages.ErrorCommPort;
                }
                return null;
            }
        });
        this.baudrate = new ComboOption((ILabel)new StringLabel(Messages.LabelCommBaudrate), COMM_BAUDRATE, baudrateValues);
        this.baudrate.setInitialValue(defaultValueId);
        this.baudrate.setDescription((Description)new XHTMLDescription(Messages.DocumentDescriptionCommBaudrate));
        return new LabelGroup(Messages.GroupSerialOptions, new PageContent[]{commPort, this.baudrate}, 2);
    }

    private Group buildPCSocketConnection() {
        TextFieldOption socketPort = new TextFieldOption((ILabel)new StringLabel(Messages.LabelServerPort), SERVER_PORT);
        socketPort.setInitialValue(DEFAULT_SERVER_PORT);
        socketPort.setDescription((Description)new XHTMLDescription(Messages.DocumentDescriptionServerPort));
        socketPort.setOptionValidator(new OptionValidator(){

            public String getErrorMessage(PageContent option) {
                TextFieldOption t = (TextFieldOption)option;
                String value = t.getSelection().trim();
                if (value.length() == 0) {
                    return Messages.ErrorServerPort;
                }
                return null;
            }
        });
        return new LabelGroup(Messages.GroupServerOptions, new PageContent[]{socketPort}, 1);
    }

    public void finalize(PagesResolver resolver) {
    }

    public Expression getVisibility() {
        return null;
    }
}

