/*
 * Java
 *
 * Copyright 2016-2018 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.ecom.wifi;

/**
 * List of possible capabilities for the underlying Wi-Fi module.
 */
public enum WifiCapability {

	/**
	 * The Wi-Fi module can act as a client and as an access point but not at the
	 * same time.
	 */
	BOTH_EXCLUSIVE,
	/**
	 * The Wi-Fi module can act as a client and as an access point at the same time.
	 */
	BOTH_SIMULTANEOUS,
	/**
	 * It is possible to join an existing wireless networks. The Wi-Fi module acts
	 * as a client.
	 */
	CLIENT,
	/**
	 * It is possible to create a new wireless network. The Wi-Fi module acts as an
	 * access point.
	 */
	SOFT_AP

}
