/*
 * Java
 *
 * Copyright 2016-2018 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.ecom.wifi;

/**
 * Software enabled Access Point (SoftAP) configuration. A SoftAP is often
 * referred to as a virtual router. A SoftAP aims at creating an access point
 * that will expose a wireless network that clients can join.
 */
public class SoftAPConfiguration {

	/**
	 * Gets SoftAP name.
	 *
	 * @return SoftAP name or <code>null</code> if not set.
	 */
	public String getName() {
		throw new RuntimeException();
	}

	/**
	 * Gets SoftAP passphrase.
	 *
	 * @return SoftAP passphrase or <code>null</code> if not set.
	 */
	public String getPassphrase() {
		throw new RuntimeException();
	}

	/**
	 * Gets SoftAP security mode.
	 *
	 * @return SoftAP security mode or <code>null</code> if not set.
	 */
	public SecurityMode getSecurityMode() {
		throw new RuntimeException();
	}

	/**
	 * Gets SoftAP SSID.
	 *
	 * @return SoftAP SSID or <code>null</code> if not set.
	 */
	public String getSSID() {
		throw new RuntimeException();
	}

	/**
	 * Sets SoftAP name.
	 *
	 * @param name
	 *            SoftAP name or <code>null</code>.
	 */
	public void setName(String name) {
		throw new RuntimeException();
	}

	/**
	 * Sets SoftAP passphrase.
	 *
	 * @param passphrase
	 *            SoftAP passphrase or <code>null</code>.
	 */
	public void setPassphrase(String passphrase) {
		throw new RuntimeException();
	}

	/**
	 * Sets SoftAP security mode.
	 *
	 * @param securityMode
	 *            SoftAP security mode or <code>null</code>.
	 */
	public void setSecurityMode(SecurityMode securityMode) {
		throw new RuntimeException();
	}

	/**
	 * Sets SoftAP SSID.
	 *
	 * @param ssid
	 *            SoftAP SSID or <code>null</code>.
	 */
	public void setSSID(String ssid) {
		throw new RuntimeException();
	}

}
