/*
 * Java
 *
 * Copyright 2019-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.library.iot.rcommand.bluetooth.commands;

import java.io.IOException;

import ej.library.iot.rcommand.bluetooth.Commands;
import ej.rcommand.CommandReader;
import ej.rcommand.CommandSender;
import ej.rcommand.synchronous.Command;

public class SendReadRequestCommand extends Command<Boolean> {

	private final short connHandle;
	private final short attributeHandle;

	public SendReadRequestCommand(short connHandle, short attributeHandle) {
		this.connHandle = connHandle;
		this.attributeHandle = attributeHandle;
	}

	@Override
	public String getName() {
		return Commands.BLUETOOTH_SEND_READ_REQUEST;
	}

	@Override
	public void writeBody(CommandSender sender) throws IOException {
		sender.sendInt(this.connHandle);
		sender.sendInt(this.attributeHandle);
	}

	@Override
	public Boolean readResponseInternal(CommandReader reader) throws IOException {
		return Boolean.valueOf(reader.readInt() == Commands.OK);
	}
}
