package ej.ecom.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

/** 
 * This interface is implemented by a {@link Connection} that is able to open an {@link InputStream}.
 */
public interface InputConnection extends Connection {

    /** 
     * Open an {@link InputStream}.
     * @throws IOException if a stream is already open
     * @return the open {@link InputStream}.
     */
    public InputStream openInputStream() throws IOException;

    /** 
     * Open a {@link DataInputStream}.
     * @throws IOException if a stream is already open
     * @return the open {@link DataInputStream}.
     */
    public DataInputStream openDataInputStream() throws IOException;
}
