package ej.ecom;

import java.security.Permission;

/**
 * This class represents access to {@link DeviceManager}.
 */
public class DeviceManagerPermission<D> extends Permission {

	/**
	 * The {@link #READ} permission is required to access to registered devices.
	 */
	public static final String READ = "read";
	
	/**
	 * The {@link #MODIFY} permission is required to be able to modify the registry.
	 */
	public static final String MODIFY = "modify";
	
	/**
	 * Create a {@link DeviceManager} permission with 
	 * @param name either {@link #READ} or {@link #MODIFY} permission name 
	 * @param deviceClass the device class on which the permission is applied 
	 */
	public DeviceManagerPermission(String name, Class<D> deviceClass){
		super(name);
		throw new RuntimeException();
	}
	
	/**
	 * @return the device class on which this permission is required 
	 */
	public Class<D> getDeviceClass(){
		throw new RuntimeException();
	}
	
	@Override
	public boolean equals(Object obj) {
		throw new RuntimeException();
	}

	@Override
	public String getActions() {
		throw new RuntimeException();
	}

	@Override
	public int hashCode() {
		throw new RuntimeException();
	}

	@Override
	public boolean implies(Permission permission) {
		throw new RuntimeException();
	}

}
