package ej.ecom;

import ej.ecom.io.Connector;

/**
 * Common superclass for a Device. 
 * When a {@link Device} implements {@link Connectable} interface, then the argument of {@link Connectable#openConnection(String)}
 * correspond to the <code>params</code> part of {@link Connector} URL specification.
 * A device is uniquely identified with its name and its hardware descriptor.
 * @see Connector  
 */
public interface Device {

	/**
	 * This value is returned by {@link #getName()} when this device is unregistered and its name is unavailable.
	 */
	String UNKNOWN_NAME = "UNKNOWN";
	
	/**
	 * Returns the device hardware descriptor.
	 * @param <D> the type of the device
	 * @return the device hardware descriptor 
	 */
	public <D extends Device> HardwareDescriptor<D> getDescriptor();
	
	/**
	 * Returns the name of the device.
	 * @return the device name, {@link #UNKNOWN_NAME} if this device is not registered and its name is unavailable.
	 */
	public String getName();
	
	/**
	 * Returns the parent of this device in the hardware topology.
	 * @return null if it is a root device.
	 */
	public Device getParent();

	/**
	 * Returns the children of this device in the hardware topology.
	 * @return an empty array if it is a leaf device.
	 */
	public Device[] getChildren();
	
}
