package ej.ecom;

import java.io.IOException;

import ej.ecom.io.Connection;
import ej.ecom.io.ConnectionNotFoundException;
import ej.ecom.io.Connector;

/**
 * Common interface for a class that is able to open a {@link Connection} from it. 
 */
public interface Connectable {

	/**
	 * Create and open a new {@link Connection}.
	 * The given <code>args</code> {@link String} format depends on the implementation of this interface. Sub-classes or sub-interfaces
	 * must specify the format of this {@link String} and the type of the returned {@link Connection}.
	 * @param args the parameters of the connection
	 * @return a new connection object.
	 * @see Connector#open(String)
	 * @throws ConnectionNotFoundException if connection protocol is not found
	 * @throws IOException if an I/O error occurs
	 */
	public Connection openConnection(String args) throws IOException;
	
}
