/*
 * Java
 *
 * Copyright 2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.microvg;

/**
 * This decoder allows to retrieve a MicroVG path command from an encoded command for a given GPU.
 */
public interface CommandDecoder {

	/**
	 * Decodes the command encoded for a GPU.
	 *
	 * @param command
	 *            the command to decode.
	 * @return a MicroVG command.
	 */
	int decodeCommand(int command);
}
