/*
 * Java
 *
 * Copyright 2016-2024 MicroEJ Corp. This file has been modified and/or created by MicroEJ Corp.
 */
package org.junit.internal;

import org.junit.Assert;

public class InexactComparisonCriteria extends ComparisonCriteria {
	public double fDelta;

	public InexactComparisonCriteria(double delta) {
		this.fDelta = delta;
	}

	public InexactComparisonCriteria(float delta) {
		this.fDelta = delta;
	}

	@Override
	protected void assertElementsEqual(Object expected, Object actual) {
		if (expected instanceof Double) {
			Assert.assertEquals(((Double) expected).doubleValue(), ((Double) actual).doubleValue(), this.fDelta);
		} else {
			Assert.assertEquals(((Float) expected).floatValue(), ((Float) actual).floatValue(), this.fDelta);
		}
	}
}