/*
 * Java
 *
 * Copyright 2017-2021 MicroEJ Corp. All rights reserved.
 * MicroEJ Corp. PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.trace;

import ej.bon.Constants;

/**
 * A {@link Tracer} object is used to trace events for debug or monitoring. {@link Tracer} are named and can produce a
 * limited number of different event types.
 * <p>
 * The following example uses a {@link Tracer} object to trace the execution of a method: <blockquote>
 *
 * <pre>
 * static final int EVT_FOO = 0;
 *
 * Trace myTracer = new Tracer("MyTracer", 1);
 *
 * int foo(int x, int y) {
 * 	myTracer.recordEvent(EVT_FOO, x, y);
 * 	...
 * 	myTracer.recordEventEnd(EVT_FOO, z);
 * 	return z;
 * }
 * </pre>
 *
 * </blockquote>
 */
public class Tracer {

	/**
	 * The value of this boolean constant property is {@code true} when the traces are enabled in the system and
	 * {@code false} otherwise (see {@link Constants}).
	 * <p>
	 * It can be used to prevent unnecessary code to be embedded and executed when the traces are disabled: <blockquote>
	 *
	 * <pre>
	 * if (Constants.getBoolean(Tracer.TRACE_ENABLED_CONSTANT_PROPERTY)) {
	 * 	int myEventValue = getMyEventValue();
	 * 	mytracer.recordEvent(myEvent, myEventValue);
	 * }
	 * </pre>
	 *
	 * </blockquote>
	 */
	public static final String TRACE_ENABLED_CONSTANT_PROPERTY = "core.trace.enabled";

	/**
	 * Starts to record the events.
	 * <p>
	 * By default, the trace system is stopped.
	 */
	public static void startTrace() {
		throw new RuntimeException();
	}

	/**
	 * Stops to record the events. When the record system is stopped, any call to the {@link #recordEvent(int)} methods
	 * will not record any events.
	 * <p>
	 * By default, the trace system is stopped.
	 */
	public static void stopTrace() {
		throw new RuntimeException();
	}

	/**
	 * Tests whether the trace system is started or not.
	 *
	 * @return <code>true</code> if the trace system is started, <code>false</code> otherwise.
	 */
	public static boolean isTraceStarted() {
		throw new RuntimeException();
	}

	/**
	 * Creates a new tracer with the given name. The created {@link Tracer} defines <code>nbEventTypes</code> types of
	 * events. The event IDs available for this group are from 0 to <code>nbEventTypes</code>-1.
	 *
	 * @param name
	 *            name that identifies the group. Must not be <code>null</code>.
	 *
	 * @param nbEventTypes
	 *            maximum number of event types available for the group.
	 *
	 * @throws InternalError
	 *             if the tracer cannot be created.
	 */
	public Tracer(String name, int nbEventTypes) throws InternalError {
		throw new RuntimeException();
	}

	/**
	 * Gets the group identifier. This identifier is unique for each {@link Tracer} instance.
	 *
	 * @return the group unique identifier.
	 */
	public int getGroupID() {
		throw new RuntimeException();
	}

	/**
	 * Record an event for this {@link Tracer}. The given event ID must be valid for this {@link Tracer} (i.e. between 0
	 * and <code>nbEventTypes</code>-1 included where <code>nbEventTypes</code> is the value given to the
	 * {@link #Tracer(String, int)} constructor).
	 * <p>
	 * The record is done only if the trace system is started (see <code>{@link #startTrace()}</code>).
	 *
	 * @param eventId
	 *            ID of the event.
	 */
	public void recordEvent(int eventId) {
		throw new RuntimeException();
	}

	/**
	 * Record an event for this {@link Tracer}. The given event ID must be valid for this {@link Tracer} (i.e. between 0
	 * and <code>nbEventTypes</code>-1 included where <code>nbEventTypes</code> is the value given to the
	 * {@link #Tracer(String, int)} constructor).
	 * <p>
	 * The record is done only if the trace system is started (see <code>{@link #startTrace()}</code>).
	 *
	 * @param eventId
	 *            ID of the event.
	 *
	 * @param value1
	 *            custom value for the event.
	 */
	public void recordEvent(int eventId, int value1) {
		throw new RuntimeException();
	}

	/**
	 * Record an event for this {@link Tracer}. The given event ID must be valid for this {@link Tracer} (i.e. between 0
	 * and <code>nbEventTypes</code>-1 included where <code>nbEventTypes</code> is the value given to the
	 * {@link #Tracer(String, int)} constructor).
	 * <p>
	 * The record is done only if the trace system is started (see <code>{@link #startTrace()}</code>).
	 *
	 * @param eventId
	 *            ID of the event.
	 *
	 * @param value1
	 *            custom value for the event.
	 *
	 * @param value2
	 *            custom value for the event.
	 */
	public void recordEvent(int eventId, int value1, int value2) {
		throw new RuntimeException();
	}

	/**
	 * Record an event for this {@link Tracer}. The given event ID must be valid for this {@link Tracer} (i.e. between 0
	 * and <code>nbEventTypes</code>-1 included where <code>nbEventTypes</code> is the value given to the
	 * {@link #Tracer(String, int)} constructor).
	 * <p>
	 * The record is done only if the trace system is started (see <code>{@link #startTrace()}</code>).
	 *
	 * @param eventId
	 *            ID of the event.
	 *
	 * @param value1
	 *            custom value for the event.
	 *
	 * @param value2
	 *            custom value for the event.
	 *
	 * @param value3
	 *            custom value for the event.
	 */
	public void recordEvent(int eventId, int value1, int value2, int value3) {
		throw new RuntimeException();
	}

	/**
	 * Record an event for this {@link Tracer}. The given event ID must be valid for this {@link Tracer} (i.e. between 0
	 * and <code>nbEventTypes</code>-1 included where <code>nbEventTypes</code> is the value given to the
	 * {@link #Tracer(String, int)} constructor).
	 * <p>
	 * The record is done only if the trace system is started (see <code>{@link #startTrace()}</code>).
	 *
	 * @param eventId
	 *            ID of the event.
	 *
	 * @param value1
	 *            custom value for the event.
	 *
	 * @param value2
	 *            custom value for the event.
	 *
	 * @param value3
	 *            custom value for the event.
	 *
	 * @param value4
	 *            custom value for the event.
	 */
	public void recordEvent(int eventId, int value1, int value2, int value3, int value4) {
		throw new RuntimeException();
	}

	/**
	 * Record an event for this {@link Tracer}. The given event ID must be valid for this {@link Tracer} (i.e. between 0
	 * and <code>nbEventTypes</code>-1 included where <code>nbEventTypes</code> is the value given to the
	 * {@link #Tracer(String, int)} constructor).
	 * <p>
	 * The record is done only if the trace system is started (see <code>{@link #startTrace()}</code>).
	 *
	 * @param eventId
	 *            ID of the event.
	 *
	 * @param value1
	 *            custom value for the event.
	 *
	 * @param value2
	 *            custom value for the event.
	 *
	 * @param value3
	 *            custom value for the event.
	 *
	 * @param value4
	 *            custom value for the event.
	 *
	 * @param value5
	 *            custom value for the event.
	 */
	public void recordEvent(int eventId, int value1, int value2, int value3, int value4, int value5) {
		throw new RuntimeException();
	}

	/**
	 * Record an event for this {@link Tracer}. The given event ID must be valid for this {@link Tracer} (i.e. between 0
	 * and <code>nbEventTypes</code>-1 included where <code>nbEventTypes</code> is the value given to the
	 * {@link #Tracer(String, int)} constructor).
	 * <p>
	 * The record is done only if the trace system is started (see <code>{@link #startTrace()}</code>).
	 *
	 * @param eventId
	 *            ID of the event.
	 *
	 * @param value1
	 *            custom value for the event.
	 *
	 * @param value2
	 *            custom value for the event.
	 *
	 * @param value3
	 *            custom value for the event.
	 *
	 * @param value4
	 *            custom value for the event.
	 *
	 * @param value5
	 *            custom value for the event.
	 *
	 * @param value6
	 *            custom value for the event.
	 */
	public void recordEvent(int eventId, int value1, int value2, int value3, int value4, int value5, int value6) {
		throw new RuntimeException();
	}

	/**
	 * Record an event for this {@link Tracer}. The given event ID must be valid for this {@link Tracer} (i.e. between 0
	 * and <code>nbEventTypes</code>-1 included where <code>nbEventTypes</code> is the value given to the
	 * {@link #Tracer(String, int)} constructor).
	 * <p>
	 * The record is done only if the trace system is started (see <code>{@link #startTrace()}</code>).
	 *
	 * @param eventId
	 *            ID of the event.
	 *
	 * @param value1
	 *            custom value for the event.
	 *
	 * @param value2
	 *            custom value for the event.
	 *
	 * @param value3
	 *            custom value for the event.
	 *
	 * @param value4
	 *            custom value for the event.
	 *
	 * @param value5
	 *            custom value for the event.
	 *
	 * @param value6
	 *            custom value for the event.
	 *
	 * @param value7
	 *            custom value for the event.
	 */
	public void recordEvent(int eventId, int value1, int value2, int value3, int value4, int value5, int value6,
			int value7) {
		throw new RuntimeException();
	}

	/**
	 * Record an event for this {@link Tracer}. The given event ID must be valid for this {@link Tracer} (i.e. between 0
	 * and <code>nbEventTypes</code>-1 included where <code>nbEventTypes</code> is the value given to the
	 * {@link #Tracer(String, int)} constructor).
	 * <p>
	 * The record is done only if the trace system is started (see <code>{@link #startTrace()}</code>).
	 *
	 * @param eventId
	 *            ID of the event.
	 *
	 * @param value1
	 *            custom value for the event.
	 *
	 * @param value2
	 *            custom value for the event.
	 *
	 * @param value3
	 *            custom value for the event.
	 *
	 * @param value4
	 *            custom value for the event.
	 *
	 * @param value5
	 *            custom value for the event.
	 *
	 * @param value6
	 *            custom value for the event.
	 *
	 * @param value7
	 *            custom value for the event.
	 *
	 * @param value8
	 *            custom value for the event.
	 */
	public void recordEvent(int eventId, int value1, int value2, int value3, int value4, int value5, int value6,
			int value7, int value8) {
		throw new RuntimeException();
	}

	/**
	 * Record an event for this {@link Tracer}. The given event ID must be valid for this {@link Tracer} (i.e. between 0
	 * and <code>nbEventTypes</code>-1 included where <code>nbEventTypes</code> is the value given to the
	 * {@link #Tracer(String, int)} constructor).
	 * <p>
	 * The record is done only if the trace system is started (see <code>{@link #startTrace()}</code>).
	 *
	 * @param eventId
	 *            ID of the event.
	 *
	 * @param value1
	 *            custom value for the event.
	 *
	 * @param value2
	 *            custom value for the event.
	 *
	 * @param value3
	 *            custom value for the event.
	 *
	 * @param value4
	 *            custom value for the event.
	 *
	 * @param value5
	 *            custom value for the event.
	 *
	 * @param value6
	 *            custom value for the event.
	 *
	 * @param value7
	 *            custom value for the event.
	 *
	 * @param value8
	 *            custom value for the event.
	 *
	 * @param value9
	 *            custom value for the event.
	 */
	public void recordEvent(int eventId, int value1, int value2, int value3, int value4, int value5, int value6,
			int value7, int value8, int value9) {
		throw new RuntimeException();
	}

	/**
	 * Record an event for this {@link Tracer}. The given event ID must be valid for this {@link Tracer} (i.e. between 0
	 * and <code>nbEventTypes</code>-1 included where <code>nbEventTypes</code> is the value given to the
	 * {@link #Tracer(String, int)} constructor).
	 * <p>
	 * The record is done only if the trace system is started (see <code>{@link #startTrace()}</code>).
	 *
	 * @param eventId
	 *            ID of the event.
	 *
	 * @param value1
	 *            custom value for the event.
	 *
	 * @param value2
	 *            custom value for the event.
	 *
	 * @param value3
	 *            custom value for the event.
	 *
	 * @param value4
	 *            custom value for the event.
	 *
	 * @param value5
	 *            custom value for the event.
	 *
	 * @param value6
	 *            custom value for the event.
	 *
	 * @param value7
	 *            custom value for the event.
	 *
	 * @param value8
	 *            custom value for the event.
	 *
	 * @param value9
	 *            custom value for the event.
	 *
	 * @param value10
	 *            custom value for the event.
	 */
	public void recordEvent(int eventId, int value1, int value2, int value3, int value4, int value5, int value6,
			int value7, int value8, int value9, int value10) {
		throw new RuntimeException();
	}

	/**
	 * Record the end of the execution of an event for this {@link Tracer}. Call this method to trace the duration of an
	 * event previously record with one of the {@link #recordEvent(int)} methods. This method should not be called for
	 * event that has no duration.
	 * <p>
	 * For example, if you want to trace the execution of a method, you can call {@link #recordEvent(int)} at the
	 * beginning of the function and {@link #recordEventEnd(int)} at the end of the function.
	 * <p>
	 * The record is done only if the trace system is started (see {@link #startTrace()}).
	 *
	 * @param eventId
	 *            ID of the event.
	 */
	public void recordEventEnd(int eventId) {
		throw new RuntimeException();
	}

	/**
	 * Record the end of the execution of an event for this {@link Tracer}. Call this method to trace the duration of an
	 * event previously record with one of the {@link #recordEvent(int)} methods. This method should not be called for
	 * event that has no duration.
	 * <p>
	 * For example, if you want to trace the execution of a method, you can call {@link #recordEvent(int)} at the
	 * beginning of the function and {@link #recordEventEnd(int, int)} at the end of the function.
	 * <p>
	 * The record is done only if the trace system is started (see {@link #startTrace()}).
	 *
	 * @param eventId
	 *            ID of the event.
	 *
	 * @param value1
	 *            custom value for the event end.
	 */
	public void recordEventEnd(int eventId, int value1) {
		throw new RuntimeException();
	}

}
