/*
 * Copyright 2024-2025 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package com.microej.wear.services;

import ej.microui.MicroUIException;

/**
 * This service allows Features to load resources.
 */
public interface ResourceService {

	/**
	 * Returns the resource path of an image.
	 *
	 * @param path
	 *            the path (relative to the Module directory).
	 * @return the resource path (absolute).
	 * @throws MicroUIException
	 *             if the resource path doesn't start with "/".
	 */
	String getImagePath(String path);
}
