/*
 * Copyright 2024 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package com.microej.wear.services;

/**
 * This service allows Features to get health information.
 */
public interface HealthService {

	/**
	 * Returns the number of steps walked in the current day.
	 *
	 * @return the number of steps.
	 */
	int getSteps();

	/**
	 * Returns the number of calories burned in the current day.
	 *
	 * @return the number of calories (in kcal).
	 */
	int getCalories();

	/**
	 * Returns the current heart rate.
	 *
	 * @return the heart rate (in bpm).
	 */
	int getHeartRate();

	/**
	 * Returns the blood peripheral oxygen saturation.
	 *
	 * @return the oxygen saturation (in %).
	 */
	int getOxygenSaturation();

	/**
	 * Returns the awake sleep duration.
	 *
	 * @return the awake sleep duration (in minutes).
	 */
	int getAwakeSleepDuration();

	/**
	 * Returns the REM sleep duration.
	 *
	 * @return the REM sleep duration (in minutes).
	 */
	int getRemSleepDuration();

	/**
	 * Returns the light sleep duration.
	 *
	 * @return the light sleep duration (in minutes).
	 */
	int getLightSleepDuration();

	/**
	 * Returns the deep sleep duration.
	 *
	 * @return the deep sleep duration (in minutes).
	 */
	int getDeepSleepDuration();
}
