/*
 * Copyright 2024-2025 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package com.microej.wear.components;

/**
 * The listener interface for receiving notifications when the time configuration of the device has changed (date,
 * time, time zone).
 */
public interface TimeConfigurationListener {

	/**
	 * Called when the time configuration of the device has changed (date, time, time zone).
	 *
	 * @param currentTime
	 *            the new time (in milliseconds, measured from the Java Epoch)
	 * @param zoneId
	 *            the new time zone ID
	 * @param zoneOffset
	 *            the new offset from UTC
	 */
	void onTimeConfigurationChanged(long currentTime, String zoneId, int zoneOffset);
}
