/*
 * Java
 *
 * Copyright 2008-2016 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.microui.display;

/**
 * A <code>DisplayFont</code> defines how text is rendered on a {@link Display}.
 * <p>
 * A <code>Font</code> is defined by one or more identifiers, a style and a descriptor. It may or may not be monospaced.
 * <p>
 * An identifier is an integer and it specifies the font's capabilities. For instance, when a font holds the
 * <code>LATIN</code> identifier, that means the font is able to render all Latin languages. If the font holds too the
 * <code>ARABIC</code> identifier, that means the font is also able to print Arabic words.
 * <p>
 * There are 80 predefined identifiers (1 to 80). A font can also hold other special identifiers that provide a useful
 * way to recognize a specific font. For instance, a font that contains some special characters as arrows, smileys, can
 * be tagged by the font's creator with a special identifier.
 * <p>
 * The style may combine several style attributes such as <code>STYLE_PLAIN</code>, <code>STYLE_BOLD</code>,
 * <code>STYLE_ITALIC</code> or <code>STYLE_UNDERLINED</code>.<br>
 * <p>
 * The descriptor is a helpful string that describes the font.
 * <p>
 * DisplayFonts are never created by applications, but are rather retrieved from the implementation environment.
 * <p>
 * An application can get all available fonts with {@link Font#getAllFonts()}, or query for a particular font: in this
 * case the implementation will return the most appropriate font matching the request.
 * <p>
 * The height gives the height of a line of text with the font.
 */
public class Font {

	/**
	 * The plain style constant. It may be combined with other style constants.
	 * <p>
	 * Value <code>0</code> is assigned to <code>STYLE_PLAIN</code>.
	 */
	public static final int STYLE_PLAIN = 0;

	/**
	 * The bold style constant. It may be combined with other style constants.
	 * <p>
	 * Value <code>1</code> is assigned to <code>STYLE_BOLD</code>.
	 */
	public static final int STYLE_BOLD = 1;

	/**
	 * The italic style constant. It may be combined with other style constants.
	 * <p>
	 * Value <code>2</code> is assigned to <code>STYLE_ITALIC</code>.
	 */
	public static final int STYLE_ITALIC = 1 << 1;

	/**
	 * The underlined style constant. It may be combined with other style constants.
	 * <p>
	 * Value <code>4</code> is assigned to <code>STYLE_UNDERLINED</code>.
	 */
	public static final int STYLE_UNDERLINED = 1 << 2;

	/**
	 * The underlined style constant. It may be combined with other style constants.
	 * <p>
	 * Value <code>8</code> is assigned to <code>STYLE_RESIZED</code>.
	 */
	public static final int STYLE_RESIZED = 1 << 3;

	/**
	 * Constant for arabic font identifier.
	 * <p>
	 * Value <code>1</code> is assigned to <code>ARABIC</code>.
	 */
	public static final int ARABIC = 1;

	/**
	 * Constant for armenian font identifier.
	 * <p>
	 * Value <code>2</code> is assigned to <code>ARMENIAN</code>.
	 */
	public static final int ARMENIAN = 2;

	/**
	 * Constant for balinese font identifier.
	 * <p>
	 * Value <code>3</code> is assigned to <code>BALINESE</code>.
	 */
	public static final int BALINESE = 3;

	/**
	 * Constant for bengali font identifier.
	 * <p>
	 * Value <code>4</code> is assigned to <code>BENGALI</code>.
	 */
	public static final int BENGALI = 4;

	/**
	 * Constant for bopomofo font identifier.
	 * <p>
	 * Value <code>5</code> is assigned to <code>BOPOMOFO</code>.
	 */
	public static final int BOPOMOFO = 5;

	/**
	 * Constant for braille font identifier.
	 * <p>
	 * Value <code>6</code> is assigned to <code>BRAILLE</code>.
	 */
	public static final int BRAILLE = 6;

	/**
	 * Constant for buginese font identifier.
	 * <p>
	 * Value <code>7</code> is assigned to <code>BUGINESE</code>.
	 */
	public static final int BUGINESE = 7;

	/**
	 * Constant for buhid font identifier.
	 * <p>
	 * Value <code>8</code> is assigned to <code>BUHID</code>.
	 */
	public static final int BUHID = 8;

	/**
	 * Constant for canadian aboriginal font identifier.
	 * <p>
	 * Value <code>9</code> is assigned to <code>CANADIAN_ABORIGINAL</code>.
	 */
	public static final int CANADIAN_ABORIGINAL = 9;

	/**
	 * Constant for cherokee font identifier.
	 * <p>
	 * Value <code>10</code> is assigned to <code>CHEROKEE</code>.
	 */
	public static final int CHEROKEE = 10;

	/**
	 * Constant for coptic font identifier.
	 * <p>
	 * Value <code>11</code> is assigned to <code>COPTIC</code>.
	 */
	public static final int COPTIC = 11;

	/**
	 * Constant for cyrillic font identifier.
	 * <p>
	 * Value <code>14</code> is assigned to <code>CYRILLIC</code>.
	 */
	public static final int CYRILLIC = 14;

	/**
	 * Constant for devanagari font identifier.
	 * <p>
	 * Value <code>16</code> is assigned to <code>DEVANAGARI</code>.
	 */
	public static final int DEVANAGARI = 16;

	/**
	 * Constant for ethiopic font identifier.
	 * <p>
	 * Value <code>17</code> is assigned to <code>ETHIOPIC</code>.
	 */
	public static final int ETHIOPIC = 17;

	/**
	 * Constant for georgian font identifier.
	 * <p>
	 * Value <code>18</code> is assigned to <code>GEORGIAN</code>.
	 */
	public static final int GEORGIAN = 18;

	/**
	 * Constant for glagolitic font identifier.
	 * <p>
	 * Value <code>19</code> is assigned to <code>GLAGOLITIC</code>.
	 */
	public static final int GLAGOLITIC = 19;

	/**
	 * Constant for greek font identifier.
	 * <p>
	 * Value <code>21</code> is assigned to <code>GREEK</code>.
	 */
	public static final int GREEK = 21;

	/**
	 * Constant for gujarati font identifier.
	 * <p>
	 * Value <code>22</code> is assigned to <code>GUJARATI</code>.
	 */
	public static final int GUJARATI = 22;

	/**
	 * Constant for gurmukhi font identifier.
	 * <p>
	 * Value <code>23</code> is assigned to <code>GURMUKHI</code>.
	 */
	public static final int GURMUKHI = 23;

	/**
	 * Constant for han font identifier.
	 * <p>
	 * Value <code>24</code> is assigned to <code>HAN</code>.
	 */
	public static final int HAN = 24;

	/**
	 * Constant for hangul font identifier.
	 * <p>
	 * Value <code>25</code> is assigned to <code>HANGUL</code>.
	 */
	public static final int HANGUL = 25;

	/**
	 * Constant for hanunoo font identifier.
	 * <p>
	 * Value <code>26</code> is assigned to <code>HANUNOO</code>.
	 */
	public static final int HANUNOO = 26;

	/**
	 * Constant for hebrew font identifier.
	 * <p>
	 * Value <code>27</code> is assigned to <code>HEBREW</code>.
	 */
	public static final int HEBREW = 27;

	/**
	 * Constant for hiragana font identifier.
	 * <p>
	 * Value <code>28</code> is assigned to <code>HIRAGANA</code>.
	 */
	public static final int HIRAGANA = 28;

	/**
	 * Constant for kannada font identifier.
	 * <p>
	 * Value <code>29</code> is assigned to <code>KANNADA</code>.
	 */
	public static final int KANNADA = 29;

	/**
	 * Constant for katakana font identifier.
	 * <p>
	 * Value <code>30</code> is assigned to <code>KATAKANA</code>.
	 */
	public static final int KATAKANA = 30;

	/**
	 * Constant for khmer font identifier.
	 * <p>
	 * Value <code>32</code> is assigned to <code>KHMER</code>.
	 */
	public static final int KHMER = 32;

	/**
	 * Constant for lao font identifier.
	 * <p>
	 * Value <code>33</code> is assigned to <code>LAO</code>.
	 */
	public static final int LAO = 33;

	/**
	 * Constant for latin font identifier.
	 * <p>
	 * Value <code>34</code> is assigned to <code>LATIN</code>.
	 */
	public static final int LATIN = 34;

	/**
	 * Constant for limbu font identifier.
	 * <p>
	 * Value <code>35</code> is assigned to <code>LIMBU</code>.
	 */
	public static final int LIMBU = 35;

	/**
	 * Constant for malayalam font identifier.
	 * <p>
	 * Value <code>36</code> is assigned to <code>MALAYALAM</code>.
	 */
	public static final int MALAYALAM = 36;

	/**
	 * Constant for mongolian font identifier.
	 * <p>
	 * Value <code>37</code> is assigned to <code>MONGOLIAN</code>.
	 */
	public static final int MONGOLIAN = 37;

	/**
	 * Constant for myanmar font identifier.
	 * <p>
	 * Value <code>38</code> is assigned to <code>MYANMAR</code>.
	 */
	public static final int MYANMAR = 38;

	/**
	 * Constant for new tai lue font identifier.
	 * <p>
	 * Value <code>39</code> is assigned to <code>NEW_TAI_LUE</code>.
	 */
	public static final int NEW_TAI_LUE = 39;

	/**
	 * Constant for nko font identifier.
	 * <p>
	 * Value <code>40</code> is assigned to <code>NKO</code>.
	 */
	public static final int NKO = 40;

	/**
	 * Constant for ogham font identifier.
	 * <p>
	 * Value <code>41</code> is assigned to <code>OGHAM</code>.
	 */
	public static final int OGHAM = 41;

	/**
	 * Constant for oriya font identifier.
	 * <p>
	 * Value <code>42</code> is assigned to <code>ORIYA</code>.
	 */
	public static final int ORIYA = 42;

	/**
	 * Constant for phags pa font identifier.
	 * <p>
	 * Value <code>44</code> is assigned to <code>PHAGS_PA</code>.
	 */
	public static final int PHAGS_PA = 44;

	/**
	 * Constant for runic font identifier.
	 * <p>
	 * Value <code>46</code> is assigned to <code>RUNIC</code>.
	 */
	public static final int RUNIC = 46;

	/**
	 * Constant for sinhala font identifier.
	 * <p>
	 * Value <code>48</code> is assigned to <code>SINHALA</code>.
	 */
	public static final int SINHALA = 48;

	/**
	 * Constant for syloti nagri font identifier.
	 * <p>
	 * Value <code>49</code> is assigned to <code>SYLOTI_NAGRI</code>.
	 */
	public static final int SYLOTI_NAGRI = 49;

	/**
	 * Constant for syriac font identifier.
	 * <p>
	 * Value <code>50</code> is assigned to <code>SYRIAC</code>.
	 */
	public static final int SYRIAC = 50;

	/**
	 * Constant for tagalog font identifier.
	 * <p>
	 * Value <code>51</code> is assigned to <code>TAGALOG</code>.
	 */
	public static final int TAGALOG = 51;

	/**
	 * Constant for tagbanwa font identifier.
	 * <p>
	 * Value <code>52</code> is assigned to <code>TAGBANWA</code>.
	 */
	public static final int TAGBANWA = 52;

	/**
	 * Constant for tai le font identifier.
	 * <p>
	 * Value <code>53</code> is assigned to <code>TAI_LE</code>.
	 */
	public static final int TAI_LE = 53;

	/**
	 * Constant for tamil font identifier.
	 * <p>
	 * Value <code>54</code> is assigned to <code>TAMIL</code>.
	 */
	public static final int TAMIL = 54;

	/**
	 * Constant for telugu font identifier.
	 * <p>
	 * Value <code>55</code> is assigned to <code>TELUGU</code>.
	 */
	public static final int TELUGU = 55;

	/**
	 * Constant for thaana font identifier.
	 * <p>
	 * Value <code>56</code> is assigned to <code>THAANA</code>.
	 */
	public static final int THAANA = 56;

	/**
	 * Constant for thai font identifier.
	 * <p>
	 * Value <code>57</code> is assigned to <code>THAI</code>.
	 */
	public static final int THAI = 57;

	/**
	 * Constant for tibetan font identifier.
	 * <p>
	 * Value <code>58</code> is assigned to <code>TIBETAN</code>.
	 */
	public static final int TIBETAN = 58;

	/**
	 * Constant for tifinagh font identifier.
	 * <p>
	 * Value <code>59</code> is assigned to <code>TIFINAGH</code>.
	 */
	public static final int TIFINAGH = 59;

	/**
	 * Constant for yi font identifier.
	 * <p>
	 * Value <code>61</code> is assigned to <code>YI</code>.
	 */
	public static final int YI = 61;

	/**
	 * Constant for common font identifier.
	 * <p>
	 * Value <code>62</code> is assigned to <code>COMMON</code>.
	 */
	public static final int COMMON = 62;

	/**
	 * Constant for inherited font identifier.
	 * <p>
	 * Value <code>63</code> is assigned to <code>INHERITED</code>.
	 */
	public static final int INHERITED = 63;

	/**
	 * Constant for sundanese font identifier.
	 * <p>
	 * Value <code>64</code> is assigned to <code>SUNDANESE</code>.
	 */
	public static final int SUNDANESE = 64;

	/**
	 * Constant for lepcha font identifier.
	 * <p>
	 * Value <code>65</code> is assigned to <code>LEPCHA</code>.
	 */
	public static final int LEPCHA = 65;

	/**
	 * Constant for ol chiki font identifier.
	 * <p>
	 * Value <code>66</code> is assigned to <code>OL_CHIKI</code>.
	 */
	public static final int OL_CHIKI = 66;

	/**
	 * Constant for vai font identifier.
	 * <p>
	 * Value <code>67</code> is assigned to <code>VAI</code>.
	 */
	public static final int VAI = 67;

	/**
	 * Constant for saurashtra font identifier.
	 * <p>
	 * Value <code>68</code> is assigned to <code>SAURASHTRA</code>.
	 */
	public static final int SAURASHTRA = 68;

	/**
	 * Constant for kayah li font identifier.
	 * <p>
	 * Value <code>69</code> is assigned to <code>KAYAH_LI</code>.
	 */
	public static final int KAYAH_LI = 69;

	/**
	 * Constant for rejang font identifier.
	 * <p>
	 * Value <code>70</code> is assigned to <code>REJANG</code>.
	 */
	public static final int REJANG = 70;

	/**
	 * Constant for cham font identifier.
	 * <p>
	 * Value <code>71</code> is assigned to <code>CHAM</code>.
	 */
	public static final int CHAM = 71;

	/**
	 * Constant for tai tham font identifier.
	 * <p>
	 * Value <code>72</code> is assigned to <code>TAI_THAM</code>.
	 */
	public static final int TAI_THAM = 72;

	/**
	 * Constant for tai viet font identifier.
	 * <p>
	 * Value <code>73</code> is assigned to <code>TAI_VIET</code>.
	 */
	public static final int TAI_VIET = 73;

	/**
	 * Constant for samaritan font identifier.
	 * <p>
	 * Value <code>74</code> is assigned to <code>SAMARITAN</code>.
	 */
	public static final int SAMARITAN = 74;

	/**
	 * Constant for lisu font identifier.
	 * <p>
	 * Value <code>75</code> is assigned to <code>LISU</code>.
	 */
	public static final int LISU = 75;

	/**
	 * Constant for bamum font identifier.
	 * <p>
	 * Value <code>76</code> is assigned to <code>BAMUM</code>.
	 */
	public static final int BAMUM = 76;

	/**
	 * Constant for javanese font identifier.
	 * <p>
	 * Value <code>77</code> is assigned to <code>JAVANESE</code>.
	 */
	public static final int JAVANESE = 77;

	/**
	 * Constant for meetei mayek font identifier.
	 * <p>
	 * Value <code>78</code> is assigned to <code>MEETEI_MAYEK</code>.
	 */
	public static final int MEETEI_MAYEK = 78;

	/**
	 * Constant for batak font identifier.
	 * <p>
	 * Value <code>79</code> is assigned to <code>BATAK</code>.
	 */
	public static final int BATAK = 79;

	/**
	 * Constant for mandaic font identifier.
	 * <p>
	 * Value <code>80</code> is assigned to <code>MANDAIC</code>.
	 */
	public static final int MANDAIC = 80;

	/**
	 * Forbidden constructor: use {@link #getAllFonts()} or {@link #getDefaultFont()} to get the available fonts.
	 *
	 * @see #getAllFonts()
	 * @see #getDefaultFont()
	 */
	Font() {
		throw new RuntimeException();
	}

	@Override
	public boolean equals(Object obj) {
		throw new RuntimeException();
	}

	@Override
	public int hashCode() {
		throw new RuntimeException();
	}

	/**
	 * Gets an array of identifiers supported by the font. An identifier is an integer specified in this class or a
	 * specific integer defined by the MicroUI implementation.
	 *
	 * @return an array of identifier.
	 */
	public int[] getIdentifiers() {
		throw new RuntimeException();
	}

	/**
	 * Checks whether the font supports the given identifier or not.
	 *
	 * @param identifier
	 *            the identifier to check.
	 * @return <code>true</code> if the font supports the given identifier, <code>false</code> otherwise.
	 */
	public boolean isIdentifierSupported(int identifier) {
		throw new RuntimeException();
	}

	/**
	 * Gets the style of the font.<br>
	 * The returned value may only be a combination of the following style constants: <code>STYLE_BOLD</code>,
	 * <code>SYTLE_ITALIC</code>, <code>STYLE_UNDERLINED</code> or <code>STYLE_PLAIN</code>.
	 *
	 * @return the style of the font
	 */
	public int getStyle() {
		throw new RuntimeException();
	}

	/**
	 * Returns the descriptor of the font or <code>null</code> if no descriptor is available.
	 *
	 * @return the descriptor of the font or <code>null</code>.
	 */
	public String getDescriptor() {
		throw new RuntimeException();
	}

	/**
	 * Gets whether the font is plain or not.
	 *
	 * @return <code>true</code> if the font is plain, <code>false</code> otherwise.
	 */
	public boolean isPlain() {
		throw new RuntimeException();
	}

	/**
	 * Gets whether the font is bold or not.
	 *
	 * @return <code>true</code> if the font is bold, <code>false</code> otherwise.
	 */
	public boolean isBold() {
		throw new RuntimeException();
	}

	/**
	 * Gets whether the font is italic or not.
	 *
	 * @return <code>true</code> if the font is italic, <code>false</code> otherwise.
	 */
	public boolean isItalic() {
		throw new RuntimeException();
	}

	/**
	 * Gets whether the font is underlined or not.
	 *
	 * @return <code>true</code> if the font is underlined, <code>false</code> otherwise.
	 */
	public boolean isUnderlined() {
		throw new RuntimeException();
	}

	/**
	 * Gets whether the font is monospaced or not.
	 * <p>
	 * A monospaced font is a font which all characters have the same width.
	 *
	 * @return <code>true</code> if the font is monospaced, <code>false</code> otherwise.
	 */
	public boolean isMonospaced() {
		throw new RuntimeException();
	}

	/**
	 * Gets the width of the specified character with this font.<br>
	 * The width is the horizontal distance that would be occupied if <code>ch</code> was drawn using this font. It also
	 * includes the horizontal space that would be added after <code>ch</code> to separate it appropriately from the
	 * following characters.
	 *
	 * @param ch
	 *            the character to measure
	 * @return the width of <code>ch</code> with this font
	 */
	public int charWidth(char ch) {
		throw new RuntimeException();
	}

	/**
	 * Gets the width of the characters in <code>ch</code> from <code>offset</code> to <code>offset+length</code> with
	 * this font.<br>
	 * The width is the horizontal distance that would be occupied if the <code>length</code> characters were drawn
	 * using this font. It also includes the horizontal spaces between characters to separate them appropriately.
	 *
	 * @param ch
	 *            an array of characters
	 * @param offset
	 *            the index of the first character to measure
	 * @param length
	 *            the number of characters to measure
	 * @return the width taken by the specified characters in <code>ch</code>
	 * @throws ArrayIndexOutOfBoundsException
	 *             if <code>offset</code> and <code>length</code> are out of <code>ch</code> range
	 * @throws NullPointerException
	 *             if <code>ch</code> is null
	 */
	public int charsWidth(char[] ch, int offset, int length) {
		throw new RuntimeException();
	}

	/**
	 * Gets the width of the given string with this font.<br>
	 * The width is the horizontal distance that would be occupied if the string was drawn using this font. It also
	 * includes the horizontal spaces between characters to separate them appropriately.
	 *
	 * @param str
	 *            the string to measure
	 * @return the width taken by the given string.
	 * @throws NullPointerException
	 *             if the given string is <code>null</code>
	 */
	public int stringWidth(String str) {
		throw new RuntimeException();
	}

	/**
	 * Gets the width of the string from <code>offset</code> to <code>offset+len</code> with this font.<br>
	 * The width is the horizontal distance that would be occupied if the substring was drawn using this font. It also
	 * includes the horizontal spaces between characters to separate them appropriately.
	 *
	 * @param str
	 *            the string to measure
	 * @param offset
	 *            index of the first character in the substring
	 * @param len
	 *            length of the substring
	 * @return the width taken by the substring of <code>str</code>
	 * @throws StringIndexOutOfBoundsException
	 *             if <code>offset</code> and <code>length</code> are out of <code>str</code> range
	 * @throws NullPointerException
	 *             if <code>str</code> is null
	 */
	public int substringWidth(String str, int offset, int len) {
		throw new RuntimeException();
	}

	/**
	 * Gets the default font for all Displays.<br>
	 * This method may return <code>null</code> if no font is declared in the system.
	 *
	 * @return the default font
	 * @throws IllegalStateException
	 *             if MicroUI is not started
	 */
	public static Font getDefaultFont() throws IllegalStateException {
		throw new RuntimeException();
	}

	/**
	 * Gets an array containing all available DisplayFonts in the system.
	 *
	 * @return an array of fonts
	 * @throws IllegalStateException
	 *             if MicroUI is not started
	 */
	public static Font[] getAllFonts() throws IllegalStateException {
		throw new RuntimeException();
	}

	/**
	 * Gets a <code>DisplayFont</code> matching the requested characteristics as close as possible.
	 * <p>
	 * Font is requested by specifying the required identifier, height and style. If no available font exactly matches
	 * the request, the system will attempt to provide the most appropriate font.
	 * <p>
	 * The implementation should use the following rules to determine a suitable font:<br>
	 * <ul>
	 * <li>A suitable font must support the specified identifier. If there is no available font with a matching
	 * identifier return the default font (null if there is no default font).</li>
	 * <li>From within the fonts that support the specified identifier, select the font that is the closest in height to
	 * the specified height. If there are two or more fonts equally close in height to the specified height select them
	 * all.</li>
	 * <li>From within the fonts selected in the previous rule, pick the font or fonts that match the most style flags.
	 * </li>
	 * <li>If more than one font is identified by the previous rule, the choice of font to return is implementation
	 * dependent (perhaps selected on the basis of which font will render at the highest quality).</li>
	 * </ul>
	 *
	 * @param identifier
	 *            the required identifier of the font.
	 * @param height
	 *            the required height of the font.
	 * @param style
	 *            the required combination of style constants.
	 * @return a <code>DisplayFont</code> object or <code>null</code>.
	 * @throws IllegalStateException
	 *             if MicroUI is not started.
	 */
	public static Font getFont(int identifier, int height, int style) throws IllegalStateException {
		throw new RuntimeException();
	}

	/**
	 * Sets x and y ratios.
	 *
	 * @param xRatio
	 *            the x ratio to set.
	 * @param yRatio
	 *            the y ratio to set.
	 * @since 1.5
	 */
	public void setRatios(float xRatio, float yRatio) {
		throw new RuntimeException();
	}

	/**
	 * Gets x ratio.
	 *
	 * @return the x ratio.
	 * @since 1.5
	 */
	public float getXRatio() {
		throw new RuntimeException();
	}

	/**
	 * Gets y ratio.
	 *
	 * @return the y ratio.
	 * @since 1.5
	 */
	public float getYRatio() {
		throw new RuntimeException();
	}

	/**
	 * Resets x and y ratios at their original value (construction value).
	 *
	 * @since 1.5
	 */
	public void resetRatios() {
		throw new RuntimeException();
	}

	/**
	 * Gets the height of a line of text with this font.
	 * <p>
	 * The height includes the size of the font as well as sufficient spacing below the text to ensure that lines of
	 * text drawn at this distance will be spaced appropriately.
	 *
	 * @return height of a line of text with this font.
	 */
	public int getHeight() {
		throw new RuntimeException();
	}

	/**
	 * Gets the distance in pixels from the top of the text to the text's baseline.<br>
	 *
	 * @return the font baseline.
	 */
	public int getBaselinePosition() {
		throw new RuntimeException();
	}

}
