/*
 * Java
 *
 * Copyright 2020-2025 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package com.microej.kf.util.message;

import ej.util.message.MessageLogger;
import ej.util.message.basic.BasicMessageBuilder;
import ej.util.message.basic.BasicMessageLogger;

/**
 * Provides a message logger to log all messages from KF utilities.
 */
public final class KfUtilMessage {

	/**
	 * KF utilities message logger.
	 */
	public static final MessageLogger LOGGER = new BasicMessageLogger(new BasicMessageBuilder());

	/**
	 * KF utilities message category.
	 */
	public static final String CATEGORY = "KfUtil";

	/**
	 * Error occurs when the framework calls user code.
	 */
	public static final int INPUT_STREAM_ERROR = 0;

	public static final int PROGRESS_MONITOR_ERROR = 1;

	public static final int PERMISSION_CHECK = 2;

	private KfUtilMessage() {
		// Forbid instantiation
	}

}
