/*
 * Copyright (c) 1997, 2013, Oracle and/or its affiliates. All rights reserved.
 * Copyright 2018-2021 MicroEJ Corp. EDC compliance and optimizations.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package java.security;

import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;

/**
 * Key factories are used to convert <I>keys</I> (opaque cryptographic keys of type {@code Key}) into <I>key
 * specifications</I> (transparent representations of the underlying key material), and vice versa.
 *
 * <P>
 * Key factories are bi-directional. That is, they allow you to build an opaque key object from a given key
 * specification (key material), or to retrieve the underlying key material of a key object in a suitable format.
 *
 * <P>
 * Multiple compatible key specifications may exist for the same key. A key factory can be used to translate between
 * compatible key specifications.
 *
 * @author Jan Luehe
 *
 * @see Key
 * @see PublicKey
 * @see PrivateKey
 * @see java.security.spec.KeySpec
 *
 * @since 1.2
 */

public class KeyFactory {

	/**
	 * Returns a KeyFactory object that converts public/private keys of the specified algorithm.
	 *
	 * @param algorithm
	 *            the name of the requested key algorithm. See the KeyFactory section in the
	 *            <a href= "{@docRoot}/../technotes/guides/security/StandardNames.html#KeyFactory"> Java Cryptography
	 *            Architecture Standard Algorithm Name Documentation</a> for information about standard algorithm names.
	 *
	 * @return the new KeyFactory object.
	 *
	 * @exception NoSuchAlgorithmException
	 *                if the KeyFactorySpi has no implementation for the specified algorithm.
	 */
	public static KeyFactory getInstance(String algorithm) throws NoSuchAlgorithmException {
		throw new RuntimeException();
	}

	/**
	 * Gets the name of the algorithm associated with this {@code KeyFactory}.
	 *
	 * @return the name of the algorithm associated with this {@code KeyFactory}
	 */
	public final String getAlgorithm() {
		throw new RuntimeException();
	}

	/**
	 * Generates a private key object from the provided key specification (key material).
	 *
	 * @param keySpec
	 *            the specification (key material) of the private key.
	 *
	 * @return the private key.
	 *
	 * @exception InvalidKeySpecException
	 *                if the given key specification is inappropriate for this key factory to produce a private key.
	 */
	public final PrivateKey generatePrivate(KeySpec keySpec) throws InvalidKeySpecException {
		throw new RuntimeException();
	}

	/**
	 * Generates a public key object from the provided key specification (key material).
	 *
	 * @param keySpec
	 *            the specification (key material) of the public key.
	 *
	 * @return the public key.
	 *
	 * @exception InvalidKeySpecException
	 *                if the given key specification is inappropriate for this key factory to produce a public key.
	 */
	public final PublicKey generatePublic(KeySpec keySpec) throws InvalidKeySpecException {
		throw new RuntimeException();
	}
}
