/*
 * Copyright (C) 2008 The Android Open Source Project
 * Copyright (C) 2015-2019 MicroEJ Corp. This file has been modified by MicroEJ Corp.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.net;

/**
 * Describes the status of a network interface.
 * <p>
 * Use {@link ConnectivityManager#getActiveNetworkInfo()} to get an instance that represents the current network
 * connection.
 */
public class NetworkInfo {
	private boolean connected;

	/**
	 *
	 */
	public NetworkInfo() {
		connected = false;
	}

	/**
	 * Indicates whether network connectivity exists and it is possible to establish connections and pass data.
	 * <p>
	 * Always call this before attempting to perform data transactions.
	 *
	 * @return {@code true} if network connectivity exists, {@code false} otherwise.
	 */
	public boolean isConnected() {
		return this.connected;
	}

	/* package */ void setConnected(boolean connected) {
		this.connected = connected;
	}
}
