/*
 * Java
 *
 * Copyright 2013-2021 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.kf;

/**
 * A {@link Module} is either Kernel or a Feature.
 * It owns a set of classes, objects, threads and stack contexts.
 */
public class Module {

	/* package */ Module() {
		throw new RuntimeException(); // not in API
	}

	/**
	 * Gets the name of this module.
	 * @return the internal name
	 */
	public String getName(){
		throw new RuntimeException();
	}

	/**
	 * Gets the identification of this module provider.
	 * @return the module identification.
	 */
	public Principal getProvider(){
		throw new RuntimeException();
	}

	/**
	 * Gets a {@link String} that represents this module version.
	 * @return the module version
	 */
	public String getVersion(){
		throw new RuntimeException();
	}

	/**
	 * Gets a byte sequence that uniquely identifies the current module.
	 * @return this module UID
	 */
	public byte[] getUID(){
		throw new RuntimeException();
	}

	/**
	 * Sets the execution quota allocated to the threads owned by this {@link Module}. This quota is expressed in execution units.<p>
	 * A Thread owned by a {@link Module} which execution quota set to <code>0</code> will never be scheduled.<p>
	 * A Thread owned by a {@link Module} which execution quota set to <code>-1</code> is always eligible to scheduling.<p>
	 * Calling this method induces a global reset of the quantum of all the Modules.
	 * <p>
	 * A {@link Module} is created with an execution quota set to <code>-1</code>.
	 * When the quota of all {@link Module} is set to <code>-1</code>, the execution counting is disabled.
	 * When the quota of a {@link Module}  is set to a value other than <code>-1</code>, the execution counting is enabled.
	 * </p>
	 * @param quota the execution quota to set to this {@link Module} in execution units
	 * @throws IllegalArgumentException if the given quota is lower than <code>-1</code>.
	 */
	public void setExecutionQuota(int quota){
		throw new RuntimeException();
	}

	/**
	 * Gets the execution quota.
	 * @return the quota of this {@link Module} in execution units.
	 */
	public int getExecutionQuota(){
		throw new RuntimeException();
	}

	/**
	 * Gets the current execution counter, since the last reset. The execution counters are reset each time {@link #setExecutionQuota(int)} is called on a {@link Module}.
	 * @return the total amount of execution units that has been consumed by threads owned by this {@link Module}, or <code>0</code> if execution counting is disabled.
	 */
	public long getExecutionCounter(){
		throw new RuntimeException();
	}

}
