/*
 * Java
 *
 * Copyright 2018 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.bluetooth;

import ej.bluetooth.callbacks.ConnectionCallbacks;

/**
 * The <code>BluetoothDevice</code> class represents a remote Bluetooth device.
 * <p>
 * Devices may be retrieved from the Bluetooth adapter by {@link BluetoothAdapter#startScanning scanning} or
 * {@link BluetoothAdapter#startAdvertising advertising}.
 * <p>
 * This class provides methods to get information on the remote device. It also allows to manage the connection with
 * this device, to manage pairing and to discover the services that the device provides.
 */
public class BluetoothDevice {

	/**
	 * Private constructor. Devices may be retrieved from an adapter by scanning or advertising.
	 */
	private BluetoothDevice() {
		throw new RuntimeException();
	}

	/**
	 * Returns the Bluetooth address of this device.
	 *
	 * @return the Bluetooth address of this device.
	 */
	public String getAddress() {
		throw new RuntimeException();
	}

	/**
	 * Returns the list of services provided by this device.
	 * <p>
	 * This method does not perform a services discovery and only returns the services which have been found earlier by
	 * {@link #discoverServices discovering services}. If the adapter is not connected to this device or if the services
	 * of this device have not been discovered so far, an empty list will be returned.
	 * <p>
	 * The GATT events related to these services may be handled by {@link BluetoothService#setClientCallbacks setting
	 * the client callbacks}.
	 *
	 * @return the list of services provided by this device.
	 * @see #findService(BluetoothUuid)
	 */
	public BluetoothService[] getServices() {
		throw new RuntimeException();
	}

	/**
	 * Returns the service with the given UUID.
	 * <p>
	 * This method is equivalent of looking up the service with the given UUID in the list returned by
	 * {@link #getServices getServices()}.
	 * <p>
	 * The GATT events related to this service may be handled by {@link BluetoothService#setClientCallbacks setting the
	 * client callbacks}.
	 *
	 * @param serviceUuid
	 *            the UUID of the service to look for.
	 * @return the service with the given UUID, or null if it not in the services list.
	 * @see #getServices()
	 */
	public BluetoothService findService(BluetoothUuid serviceUuid) {
		throw new RuntimeException();
	}

	/**
	 * Initiates connection with this device.
	 * <p>
	 * The connectionCallbacks object will receive the connection events.
	 *
	 * @param connectionCallbacks
	 *            the object which will receive the connection events.
	 * @return true if connection was initiated successfully, false otherwise.
	 * @see ConnectionCallbacks#onConnectFailed(BluetoothDevice)
	 * @see ConnectionCallbacks#onConnected(BluetoothDevice)
	 */
	public boolean connect(ConnectionCallbacks connectionCallbacks) {
		throw new RuntimeException();
	}

	/**
	 * Initiates disconnection with this device.
	 *
	 * @return true if disconnection was initiated successfully, false otherwise.
	 * @see ConnectionCallbacks#onDisconnected(BluetoothDevice)
	 */
	public boolean disconnect() {
		throw new RuntimeException();
	}

	/**
	 * Returns whether the adapter is currently connected to this device.
	 *
	 * @return true if the adapter is connected to this device, false otherwise.
	 */
	public boolean isConnected() {
		throw new RuntimeException();
	}

	/**
	 * Initiates pairing with this device.
	 * <p>
	 * This operation may only be performed while connected to this device.
	 *
	 * @return true if pairing was initiated successfully, false otherwise.
	 * @see ConnectionCallbacks#onPairCompleted(BluetoothDevice, boolean)
	 * @see ConnectionCallbacks#onPasskeyRequest(BluetoothDevice)
	 */
	public boolean pair() {
		throw new RuntimeException();
	}

	/**
	 * Replies to the pairing request of this device.
	 * <p>
	 * This operation may only be performed after received a pairing request.
	 *
	 * @param accept
	 *            true if the pairing request should be accepted, false otherwise.
	 * @return true if the reply was sent successfully, false otherwise.
	 * @see ConnectionCallbacks#onPairCompleted(BluetoothDevice, boolean)
	 * @see ConnectionCallbacks#onPasskeyGenerated(BluetoothDevice, int)
	 */
	public boolean pairReply(boolean accept) {
		throw new RuntimeException();
	}

	/**
	 * Replies to the passkey request of this device.
	 * <p>
	 * This operation may only be performed after received a passkey request.
	 *
	 * @param accept
	 *            true if the passkey request should be accepted, false otherwise.
	 * @param passkey
	 *            the passkey value (6-digits PIN code).
	 * @return true if the reply was sent successfully, false otherwise.
	 * @see ConnectionCallbacks#onPairCompleted(BluetoothDevice, boolean)
	 */
	public boolean passkeyReply(boolean accept, int passkey) {
		throw new RuntimeException();
	}

	/**
	 * Initiates the discovery of the services provided by this device.
	 * <p>
	 * This operation may only be performed while connected to this device.
	 *
	 * @return true if services discovery was initiated successfully, false otherwise.
	 * @see ConnectionCallbacks#onServicesDiscovered(BluetoothDevice)
	 */
	public boolean discoverServices() {
		throw new RuntimeException();
	}
}
