/*
 * Java
 *
 * Copyright 2018 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.bluetooth;

import ej.bluetooth.callbacks.ClientCallbacks;

/**
 * The <code>BluetoothAttribute</code> class represents a remote or a local GATT attribute.
 * <p>
 * This class provides methods to get information on the attribute. It also provides methods to send read or write
 * requests to a remote attribute, and methods to send read or write responses on a local attribute.
 * <p>
 * Please refer to the child classes documentation for more information.
 */
public class BluetoothAttribute {

	/**
	 * Package-private constructor. Local attributes may be created using the constructor of the child class.
	 */
	/* package */ BluetoothAttribute() {
		throw new RuntimeException();
	}

	/**
	 * Returns the UUID of this attribute.
	 *
	 * @return the UUID of this attribute.
	 */
	public BluetoothUuid getUuid() {
		throw new RuntimeException();
	}

	/**
	 * Returns the service to which this attribute belongs.
	 * <p>
	 * This method returns null if this is a local attribute which has not been added to a service.
	 *
	 * @return the service to which this attribute belongs.
	 */
	public BluetoothService getService() {
		throw new RuntimeException();
	}

	/**
	 * Sends a read request on this attribute.
	 *
	 * @return true if the read request was sent successfully.
	 * @throws IllegalStateException
	 *             if this attribute does not belong to a remote device.
	 * @see ClientCallbacks#onReadCompleted(BluetoothCharacteristic, int, byte[])
	 * @see ClientCallbacks#onReadCompleted(BluetoothDescriptor, int, byte[])
	 */
	public boolean sendReadRequest() {
		throw new RuntimeException();
	}

	/**
	 * Sends a write request on this attribute with the given value.
	 *
	 * @param value
	 *            the value to write.
	 * @return true if the write request was sent successfully.
	 * @throws IllegalStateException
	 *             if this attribute does not belong to a remote device.
	 * @see ClientCallbacks#onWriteCompleted(BluetoothCharacteristic, int)
	 * @see ClientCallbacks#onWriteCompleted(BluetoothDescriptor, int)
	 */
	public boolean sendWriteRequest(byte[] value) {
		throw new RuntimeException();
	}

	/**
	 * Sends the response to a read request sent by the given device on this attribute.
	 *
	 * @param device
	 *            the device which sent the request.
	 * @param status
	 *            the status to send back (see {@link BluetoothStatus}).
	 * @param value
	 *            the value to send back.
	 * @return true if the read response was sent successfully.
	 * @throws IllegalStateException
	 *             if this attribute belongs to a remote device.
	 * @throws IllegalStateException
	 *             if this attribute has not been added to a service
	 * @throws IllegalStateException
	 *             if the service of this attribute has not been added to an adapter.
	 */
	public boolean sendReadResponse(BluetoothDevice device, int status, byte[] value) {
		throw new RuntimeException();
	}

	/**
	 * Sends the response to a write request sent by the given device on this attribute.
	 *
	 * @param device
	 *            the device which sent the request.
	 * @param status
	 *            the status to send back (see {@link BluetoothStatus}).
	 * @return true if the write response was sent successfully.
	 * @throws IllegalStateException
	 *             if this attribute belongs to a remote device.
	 * @throws IllegalStateException
	 *             if this attribute has not been added to a service
	 * @throws IllegalStateException
	 *             if the service of this attribute has not been added to an adapter.
	 */
	public boolean sendWriteResponse(BluetoothDevice device, int status) {
		throw new RuntimeException();
	}
}
