/*
 * Java
 *
 * Copyright 2018 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.bluetooth;

import ej.bluetooth.callbacks.AdvertisementCallbacks;
import ej.bluetooth.callbacks.ConnectionCallbacks;
import ej.bluetooth.callbacks.ScanCallbacks;

/**
 * The <code>BluetoothAdapter</code> class represents a Bluetooth adapter.
 * <p>
 * The default adapter may be retrieved by calling {@link #getDefaultAdapter getDefaultAdapter()}.
 * <p>
 * This class provides methods to retrieve information on the adapter, such as its name and its address. It also
 * provides methods to retrieve the list of devices known by the adapter and the list of connected devices. A Bluetooth
 * adapter is able to scan in order to find nearby devices. It is also able to advertise in order to be found by other
 * devices. The GATT server of the adapter may be configured by adding services.
 */
public class BluetoothAdapter {

	/**
	 * Private constructor. The default adapter may be retrieved by calling {@link #getDefaultAdapter
	 * getDefaultAdapter()}.
	 */
	private BluetoothAdapter() {
		throw new RuntimeException();
	}

	/**
	 * Returns the default adapter of the system.
	 *
	 * @return the default adapter.
	 */
	public static BluetoothAdapter getDefaultAdapter() {
		throw new RuntimeException();
	}

	/**
	 * Returns the list of devices known by this adapter.
	 * <p>
	 * This method does not start scanning and only returns devices which have been found earlier by
	 * {@link #startScanning scanning} or {@link #startAdvertising advertising}.
	 *
	 * @return the list of devices known by this adapter.
	 */
	public BluetoothDevice[] getDevices() {
		throw new RuntimeException();
	}

	/**
	 * Cleanups the list of devices known by this adapter.
	 * <p>
	 * All devices are removed from the list except the devices to which this adapter is connected.
	 */
	public void cleanupDevices() {
		throw new RuntimeException();
	}

	/**
	 * Returns the list of devices to which this adapter is connected.
	 *
	 * @return the list of devices to which this adapter is connected.
	 */
	public BluetoothDevice[] getConnectedDevices() {
		throw new RuntimeException();
	}

	/**
	 * Returns the list of services provided by this adapter.
	 * <p>
	 * This method basically returns the list of services added using {@link #addService addService()}.
	 *
	 * @return the list of services provided by this adapter.
	 * @see #findService(BluetoothUuid)
	 */
	public BluetoothService[] getServices() {
		throw new RuntimeException();
	}

	/**
	 * Returns the service with the given UUID.
	 * <p>
	 * This method basically returns the service with the given UUID that was added using {@link #addService
	 * addService()}.
	 *
	 * @param serviceUuid
	 *            the UUID of the service to look for.
	 * @return the service with the given UUID, or null if it not in the services list.
	 * @see #getServices()
	 */
	public BluetoothService findService(BluetoothUuid serviceUuid) {
		throw new RuntimeException();
	}

	/**
	 * Adds the given service to this adapter.
	 * <p>
	 * A service may not be added twice.
	 *
	 * @param service
	 *            the service to add.
	 * @return true if the service was added successfully, false otherwise.
	 * @throws IllegalArgumentException
	 *             if the given service has already been added to this adapter.
	 */
	public boolean addService(BluetoothService service) {
		throw new RuntimeException();
	}

	/**
	 * Starts scanning.
	 * <p>
	 * The scanCallbacks object will receive the scan events.
	 *
	 * @param scanCallbacks
	 *            the object which will receive the scan events.
	 * @return true if scanning was started successfully, false otherwise.
	 * @see ScanCallbacks#onScanResult(BluetoothAdapter, BluetoothDevice, byte[], int)
	 * @see ScanCallbacks#onScanCompleted(BluetoothAdapter)
	 * @throws IllegalStateException
	 *             if this adapter is already scanning.
	 */
	public boolean startScanning(ScanCallbacks scanCallbacks) {
		throw new RuntimeException();
	}

	/**
	 * Stops scanning.
	 *
	 * @return true if scanning was stopped successfully, false otherwise.
	 * @see ScanCallbacks#onScanCompleted(BluetoothAdapter)
	 */
	public boolean stopScanning() {
		throw new RuntimeException();
	}

	/**
	 * Returns whether this adapter is currently scanning.
	 *
	 * @return true if this adapter is currently scanning, false otherwise.
	 */
	public boolean isScanning() {
		throw new RuntimeException();
	}

	/**
	 * Starts advertising.
	 * <p>
	 * The advertisementCallbacks object will receive the advertisement events and the connectionCallbacks object will
	 * receive the connection events if a remote device connects to this adapter.
	 *
	 * @param advertisementCallbacks
	 *            the object which will receive the advertisement events.
	 * @param connectionCallbacks
	 *            the object which will receive the connection events.
	 * @param payload
	 *            the advertisement payload.
	 * @return true if advertising was started successfully, false otherwise.
	 * @see AdvertisementCallbacks#onAdvertisementCompleted(BluetoothAdapter)
	 * @see ConnectionCallbacks#onConnected(BluetoothDevice)
	 * @throws IllegalStateException
	 *             if this adapter is already advertising.
	 */
	public boolean startAdvertising(AdvertisementCallbacks advertisementCallbacks,
			ConnectionCallbacks connectionCallbacks, byte[] payload) {
		throw new RuntimeException();
	}

	/**
	 * Stops advertising.
	 *
	 * @return true if advertising was stopped successfully, false otherwise.
	 * @see AdvertisementCallbacks#onAdvertisementCompleted(BluetoothAdapter)
	 */
	public boolean stopAdvertising() {
		throw new RuntimeException();
	}

	/**
	 * Returns whether this adapter is currently advertising.
	 *
	 * @return true if this adapter is currently advertising, false otherwise.
	 */
	public boolean isAdvertising() {
		throw new RuntimeException();
	}
}
