/*
 * Copyright 2016-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.mwt.stylesheet.selector.combinator;

import ej.mwt.Widget;
import ej.mwt.stylesheet.selector.Selector;

/**
 * An 'and' combinator selects the widgets selected by both selectors.
 */
public class AndCombinator extends Combinator {

	/**
	 * Creates an 'and' combinator.
	 *
	 * @param selector1
	 *            the first selector.
	 * @param selector2
	 *            the second selector.
	 */
	public AndCombinator(Selector selector1, Selector selector2) {
		super(selector1, selector2);
	}

	@Override
	public boolean appliesToWidget(Widget widget) {
		// check that both selectors applies to widget
		return getFirstSelector().appliesToWidget(widget) && getSecondSelector().appliesToWidget(widget);
	}
}
