/*
 * Java
 *
 * Copyright 2019-2023 MicroEJ Corp. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be found with this software.
 */
package ej.library.iot.rcommand.bluetooth.notifications;

import java.io.IOException;

import ej.library.iot.rcommand.bluetooth.BluetoothHost;
import ej.library.iot.rcommand.bluetooth.Commands;
import ej.rcommand.CommandReader;
import ej.rcommand.RemoteNotificationListener;

public class EventNotificationListener implements RemoteNotificationListener {

	@Override
	public String getName() {
		return Commands.BLUETOOTH_EVENT;
	}

	@Override
	public void notificationReceived(CommandReader commandReader) {
		try {
			byte[] event = commandReader.readByteArray();
			BluetoothHost.getInstance().pushEvent(event);
		} catch (IOException e) {
			// ignore this exception
		}
	}
}
