/*
 * Java
 *
 * Copyright 2018 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.microej.kf.util;

import ej.kf.Converter;
import ej.kf.Feature;
import ej.kf.Kernel;

/**
 * A {@link Converter} for {@link Float}. This converter creates a clone of the original {@link Float}.
 */
public class FloatConverter implements Converter<Float> {

	@Override
	public Float convert(Float arg0, Feature targetOwner) throws IllegalAccessError {
		final float value = arg0.floatValue();
		RunnableWithResult<Float> runnable = new RunnableWithResult<Float>() {
			@Override
			public Float runWithResult() {
				return new Float(value);
			}
		};
		Kernel.runUnderContext(targetOwner, runnable);
		return runnable.getResult();
	}

	@Override
	public Class<Float> getType() {
		return Float.class;
	}

}