/*
 * Java
 *
 * Copyright 2015-2017 IS2T. All rights reserved.
 * IS2T PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package ej.rcommand;

import java.io.IOException;
import java.io.InputStream;

/**
 *
 */
public interface CommandReader {

	/**
	 * Reads a command.
	 *
	 * @return the command name.
	 * @throws IOException
	 *             the stream has been closed and the contained input stream does not support reading after close, or
	 *             another I/O error occurs.
	 */
	String readCommand() throws IOException;

	/**
	 * Reads a string parameter.
	 *
	 * @return the read string.
	 * @throws IOException
	 *             the stream has been closed and the contained input stream does not support reading after close, or
	 *             another I/O error occurs.
	 */
	String readString() throws IOException;

	/**
	 * Reads a long parameter.
	 *
	 * @return the read long.
	 * @throws IOException
	 *             the stream has been closed and the contained input stream does not support reading after close, or
	 *             another I/O error occurs.
	 */
	long readLong() throws IOException;

	/**
	 * Reads an integer parameter.
	 *
	 * @return the read integer.
	 * @throws IOException
	 *             the stream has been closed and the contained input stream does not support reading after close, or
	 *             another I/O error occurs.
	 */
	int readInt() throws IOException;

	/**
	 * Reads a float parameter.
	 *
	 * @return the read float.
	 * @throws IOException
	 *             the stream has been closed and the contained input stream does not support reading after close, or
	 *             another I/O error occurs.
	 */
	float readFloat() throws IOException;

	/**
	 * Reads a double parameter.
	 *
	 * @return the read double.
	 * @throws IOException
	 *             the stream has been closed and the contained input stream does not support reading after close, or
	 *             another I/O error occurs.
	 */
	double readDouble() throws IOException;

	/**
	 * Reads a boolean parameter.
	 *
	 * @return the read boolean.
	 * @throws IOException
	 *             the stream has been closed and the contained input stream does not support reading after close, or
	 *             another I/O error occurs.
	 */
	boolean readBoolean() throws IOException;

	/**
	 * Reads a byte array parameter.
	 *
	 * @return the read byte array.
	 * @throws IOException
	 *             the stream has been closed and the contained input stream does not support reading after close, or
	 *             another I/O error occurs.
	 */
	byte[] readByteArray() throws IOException;

	/**
	 * Reads a byte array using an input stream.
	 * <p>
	 * The returned input stream must be fully read before returning the method.
	 *
	 * @return an inputStream that reads the underlying byte array.
	 * @throws IOException
	 *             the stream has been closed and the contained input stream does not support reading after close, or
	 *             another I/O error occurs.
	 * @deprecated Use readByteArray or readInputStream instead.
	 */
	@Deprecated
	InputStream readByteArrayAsInputStream() throws IOException;

	/**
	 * Reads an input stream.
	 * <p>
	 * The returned input stream must be fully read before returning the method.
	 *
	 * @return an inputStream.
	 * @throws IOException
	 *             the stream has been closed and the contained input stream does not support reading after close, or
	 *             another I/O error occurs.
	 */
	InputStream readInputStream() throws IOException;

	/**
	 * Skips the parameters of a command and get ready to read the following command.
	 */
	void skipParameters() throws IOException;

}