/*
 * Copyright 2019-2020 MicroEJ Corp. All rights reserved.
 * This library is provided in source code for use, modification and test, subject to license terms.
 * Any modification of the source code will break MicroEJ Corp. warranties on the whole library.
 */
package ej.mwt.stylesheet;

import ej.mwt.Widget;
import ej.mwt.style.EditableStyle;
import ej.mwt.style.Style;

/**
 * Stylesheet that always returns the default style.
 */
public class VoidStylesheet implements Stylesheet {

	private final Style defaultStyle;

	/**
	 * Creates a void stylesheet.
	 */
	public VoidStylesheet() {
		this.defaultStyle = new EditableStyle();
	}

	@Override
	public Style getStyle(Widget widget) {
		return this.defaultStyle;
	}
}
